@extends('front.layouts.master')
@section('title','QR Yazılım - İleri Teknoloji')
@section('description', 'Quark yazılımlarını hiçbir ücret karşılığı olmadan deneyebilir ve detaylıbilgi almak için 0850 302 16 05 numarasını arayarak Quark programlarıyla ilgili detaylı bilgi alabilirsiniz.')
@section('keywords', 'demo, ticari demo, ön muhasebe, ön muhasebe programı, ön muhasebe programı demo')
@section('menustyle','light')
@section("css")
    <link href="{{ URL::asset('/dashboard/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet">

@endsection
@section('content')
    @include('front.form.model.Demoindirmodel')
    @include('front.form.model.DemoindirmodelHizliSatis')
    @include('front.form.model.DemoindirmodelMobil')
    


    @if(Illuminate\Support\Facades\Cache::has('uyari'))
        <div class="alert alert-success" id="sa-onaylandı" role="alert">{{Illuminate\Support\Facades\Cache::get('uyari')}}</div>
        <td>
            <a style="cursor:pointer;" data-dataid="" data-title="" id="sa-onaylandı" ><i style="color: red;" data-feather="trash-2"></i>gfdgdfg</a>
        </td>
    @endif
    
    <!-- PAGE HERO
			============================================= -->
    <div id="download-page" class="page-hero-section division">
        <div class="page-hero-overlay division">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-10 col-xl-8">
                        <div class="hero-txt text-center white-color">

                            <!-- Title -->
                            <h3 class="h3-xl">Quark Yazılımlarını Ücretsiz Deneyin.</h3>

                            <!-- Text -->
                            <p class="p-xl">Quark yazılımlarını hiçbir ücret karşılığı olmadan deneyebilir ve detaylı
                                bilgi almak için 0850 302 16 05 numarasını arayarak Quark programlarıyla ilgili detaylı
                                bilgi alabilirsiniz.
                            </p>

                        </div>
                    </div>
                </div>      <!-- End row -->
            </div>       <!-- End container -->
        </div>     <!-- End hero-overlay -->


        <!-- WAVE SHAPE BOTTOM -->
        <div class="wave-shape-bottom">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 80">
                <path fill="#ffffff" fill-opacity="1"
                      d="M0,32L120,42.7C240,53,480,75,720,74.7C960,75,1200,53,1320,42.7L1440,32L1440,320L1320,320C1200,320,960,320,720,320C480,320,240,320,120,320L0,320Z"></path>
            </svg>
        </div>


    </div>    <!-- END PAGE HERO -->




    <!-- DOWNLOAD-1
    ============================================= -->
    <section id="download-1" class="bg-snow wide-20 download-section division">
        <div class="container">
            <div class="row justify-content-center">

                <div class="col-xl-10">
                    <h4>Demo Quark programları hakkında;</h4>
                <ul class="simple-list">

                    <li class="list-item">
                        <p class="p-lg">Gerekli bilgileri girip kaydettikten sonra indirmiş olduğunuz demo programda sınırlı sayıda <b><i>cari, stok, fatura, fiş vb.</i></b> işlemler yapabilirsiniz.
                        </p>
                    </li>

                    <li class="list-item">
                        <p class="p-lg">İndirmiş olduğunuz program internet bağlantısı gerekmeksizin kullanabilirsiniz.</p>
                    </li>

                    <li class="list-item">
                        <p class="p-lg">İndirme, kurulum veya programla ilgili herhangi bir sorunuz varsa +90(551) 047 57 86 nolu telefon hattımızı arayıp yardım alabilirsiniz.
                        </p>
                    </li>

                </ul>

            </div>

                <div class="col-xl-5">
                    <br>
                    <hr class="divider">
                    <br>
                </div>

                <div class="col-xl-10">
                    @foreach($urunler as $urun)

                    <!-- Quark Ticari -->
                    <div class="version-release">

                        <!-- Release Data -->
                        <div class="release-data">

                            <h4 class="h4-xs" style="color: {{$urun->program_ucretsiz_deneme_renk}};">{{$urun->program_adi}}</h4>

                            <!-- Version Data -->
                            <div class="rel">
                                <span class="version-data">{{str_replace(" ", ".",$urun->lastversiyon->program_versiyon) }}</span>
                                <span class="release-date">{{$urun->lastversiyon->created_at}} <span>52.84 MB</span></span>
                                <a type="button" class="btn btn-tra-grey skyblue-hover ico-15 ico-left release-download"
                                   data-bs-toggle="modal" data-bs-target="{{$urun->lastversiyon->program_modal_name}}">
                                    <img src="{{$urun->program_icon}}" style="width: 20px; height: auto" class="card-img-top mr-10" alt="{{$urun->program_adi}}">
                                    <span type="button" data-bs-toggle="modal" data-bs-target="#staticBackdrop"
                                          class="flaticon-down-arrow"></span> İndir | {{$urun->lastversiyon->program_versiyon}}
                                </a>

                                <!-- Button trigger modal -->
                                <!-- Button trigger modal -->
                                {{--                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop">--}}
                                {{--                                    Launch static backdrop modal--}}
                                {{--                                </button>--}}


                            </div>
                        </div>


                        <!-- Release Highlights -->
                        <div class="release-highlights">
                            <ul class="simple-list">
                                {!! $urun->lastversiyon->program_aciklama !!}

                            </ul>
                        </div>
                        <br>
                        <hr class="divider">
                    </div>    <!-- END VERSION RELEASE -->


                    @endforeach



                    {{--                    <!-- Quark Res -->--}}
                    {{--                    <div class="version-release">--}}

                    {{--                        <!-- Release Data -->--}}
                    {{--                        <div class="release-data">--}}

                    {{--                            <h4 class="h4-xs">Quark Restaurant</h4>--}}

                    {{--                            <!-- Version Data -->--}}
                    {{--                            <div class="rel">--}}
                    {{--                                <span class="version-data">V1.0.1</span>--}}
                    {{--                                <span class="release-date"> - <span>40.26 MB</span></span>--}}
                    {{--                                <a href="download/example.zip" download="example.zip"--}}
                    {{--                                   class="btn btn-tra-grey skyblue-hover ico-15 ico-left release-download">--}}
                    {{--                                    <span class="flaticon-down-arrow"></span> İndir V1.0.1--}}
                    {{--                                </a>--}}
                    {{--                            </div>--}}

                    {{--                        </div>--}}

                    {{--                        <!-- Release Highlights -->--}}
                    {{--                        <div class="release-highlights">--}}
                    {{--                            <ul class="simple-list">--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixes integer cursus orci bugs on 10.13 (High Sierra)</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixed auctor integer cursus orci vitae auctor integer</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixed Crash#8341689840</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixes other minor bugs</p>--}}
                    {{--                                </li>--}}

                    {{--                            </ul>--}}
                    {{--                        </div>--}}


                    {{--                    </div>    <!-- END VERSION RELEASE -->--}}

                    {{--                    <!-- Quark Pos Lite -->--}}
                    {{--                    <div class="version-release">--}}

                    {{--                        <!-- Release Data -->--}}
                    {{--                        <div class="release-data">--}}

                    {{--                            <h4 class="h4-xs">Quark Pos Lite</h4>--}}

                    {{--                            <!-- Version Data -->--}}
                    {{--                            <div class="rel">--}}
                    {{--                                <span class="version-data">V1.0.1</span>--}}
                    {{--                                <span class="release-date"> - <span>40.26 MB</span></span>--}}
                    {{--                                <a href="download/example.zip" download="example.zip"--}}
                    {{--                                   class="btn btn-tra-grey skyblue-hover ico-15 ico-left release-download">--}}
                    {{--                                    <span class="flaticon-down-arrow"></span> İndir V1.0.1--}}
                    {{--                                </a>--}}
                    {{--                            </div>--}}

                    {{--                        </div>--}}

                    {{--                        <!-- Release Highlights -->--}}
                    {{--                        <div class="release-highlights">--}}
                    {{--                            <ul class="simple-list">--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixes integer cursus orci bugs on 10.13 (High Sierra)</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixed auctor integer cursus orci vitae auctor integer</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixed Crash#8341689840</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixes other minor bugs</p>--}}
                    {{--                                </li>--}}

                    {{--                            </ul>--}}
                    {{--                        </div>--}}


                    {{--                    </div>    <!-- END VERSION RELEASE -->--}}

                    {{--                    <!-- Quark Sulama -->--}}
                    {{--                    <div class="version-release">--}}

                    {{--                        <!-- Release Data -->--}}
                    {{--                        <div class="release-data">--}}

                    {{--                            <h4 class="h4-xs">Quark Sulama</h4>--}}

                    {{--                            <!-- Version Data -->--}}
                    {{--                            <div class="rel">--}}
                    {{--                                <span class="version-data">V1.0.1</span>--}}
                    {{--                                <span class="release-date"> - <span>40.26 MB</span></span>--}}
                    {{--                                <a href="download/example.zip" download="example.zip"--}}
                    {{--                                   class="btn btn-tra-grey skyblue-hover ico-15 ico-left release-download">--}}
                    {{--                                    <span class="flaticon-down-arrow"></span> İndir V1.0.1--}}
                    {{--                                </a>--}}
                    {{--                            </div>--}}

                    {{--                        </div>--}}

                    {{--                        <!-- Release Highlights -->--}}
                    {{--                        <div class="release-highlights">--}}
                    {{--                            <ul class="simple-list">--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixes integer cursus orci bugs on 10.13 (High Sierra)</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixed auctor integer cursus orci vitae auctor integer</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixed Crash#8341689840</p>--}}
                    {{--                                </li>--}}

                    {{--                                <li class="list-item">--}}
                    {{--                                    <p class="p-lg">Fixes other minor bugs</p>--}}
                    {{--                                </li>--}}

                    {{--                            </ul>--}}
                    {{--                        </div>--}}


                    {{--                    </div>    <!-- END VERSION RELEASE -->--}}


                </div>
            </div>    <!-- End row -->
        </div>     <!-- End container -->
    </section>    <!-- END DOWNLOAD-1 -->




    <!-- DIVIDER LINE -->
    <hr class="divider">


 <!--  ABONE OL -->
    <section id="newsletter-1" class="newsletter-section division">
        <div class="container">
            <div class="newsletter-wrapper bg-white">
                <div class="row d-flex align-items-center row-cols-1 row-cols-lg-2">


                    <!-- NEWSLETTER TEXT -->
                    <div class="col">
                        <div class="newsletter-txt pr-20">
                            <p class="p">Sizde Quark Ticari'yi denemek için ve diğer tüm sorular için bize
                                bilgi@qryazilim.com mail üzerinden ya da +90(551) 047 57 86 numarasından
                                ulaşabilirsiniz.</p>
                        </div>
                    </div>


                    <!-- NEWSLETTER FORM -->
                    <div class="col">

                        @include('front.tekparca.aboneolparca')

                    </div>      <!-- END NEWSLETTER FORM -->


                </div>      <!-- End row -->
            </div>    <!-- End newsletter-wrapper -->
        </div>       <!-- End container -->
    </section>    <!-- END NEWSLETTER-1 -->


@endsection

@section("js")
    <script src="{{ URL::asset('/dashboard/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>
    <script src="{{ URL::asset('/dashboard/assets/js/pages/sweetalert.init.js') }}"></script>
    <script>
        var myModal = document.getElementById('staticBackdrop')
        var myInput = document.getElementById('staticBackdrop')

        myModal.addEventListener('shown.bs.modal', function () {
            myInput.focus()
        })
    </script>
@endsection
