@extends('front.layouts.master')
@section('title','QR Yazılım - İleri Teknoloji')
@section('description', 'QR Yazılım sizlere ve firmalarınıza özel yazdığımız yazılımlarla hep bir adım önde olmanızı sağlar.')
@section('keywords', '')
@section('menustyle','light')
@section('content')


    <!-- HERO-17
			============================================= -->
    <section id="hero-17" class="bg-scroll rel hero-section division">
        <div class="container">


            <!-- HERO TITLE -->
            <div class="row">
                <div class="col-md-9 col-lg-8">
                    <div class="hero-17-title white-color mb-50">
                        <h2 class="h2-xl">Quark Ticari Programımızı Ücretsiz Deneyin</h2>
                    </div>
                </div>
            </div>


            <div class="row">


                <!-- HERO TEXT -->
                <div class="col-md-6 col-lg-5">
                    <div class="hero-17-txt">

                        <!-- Text -->
                        <p class="p-xl white-color">Quark ürünleri kullanıcı dostu arayüz, hızlı ve size özel çözümlerle firmalarınız için her zaman bir adım önde olmanız için kullanıma hazır.
                        </p>

                        <!-- DOWNLOAD BUTTON -->
                        <a href="{{route('demoindir')}}" class="os-btn bg-white d-flex align-items-center">

                            <!-- Icon -->
                            <div class="os-btn-ico">
                                <div class="ico-50">
                                    <img src="images/png-icons/windows.png" alt="os-icon"/>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="os-btn-txt">
                                <h6 class="h6-lg">Windows için indir</h6>
                                <p> Ücretsiz deneyin </p>
                            </div>

                        </a>


                        <!-- Advantages List -->
                        <ul class="advantages white-color clearfix mt-30">
                            <li class="first-li"><p>Version 5.0.1</p></li>
                            <li class="last-li"><p>Demo Sürümü</p></li>
                        </ul>

                    </div>
                </div>


                <!-- HERO IMAGE -->
                <div class="col-md-6 col-lg-7">
                    <div class="hero-17-img video-preview">
                        <img class="img-fluid" src="images/dashboard-04.webp" alt="hero-image">
                    </div>
                </div>


            </div>    <!-- End row -->
        </div>       <!-- End container -->
    </section>    <!-- END HERO-17 -->




    {{--    <section id="hero-11" class="bg-whitesmoke-gradient hero-section division">--}}
    {{--        <div class="container">--}}
    {{--            <div class="row d-flex align-items-center">--}}


    {{--                <!-- HERO IMAGE -->--}}
    {{--                <div class="col-md-5 col-lg-6 order-last order-md-2">--}}
    {{--                    <div class="hero-11-img text-center">--}}
    {{--                        <img class="img-fluid" src="images/img-07.png" alt="hero-image">--}}
    {{--                    </div>--}}
    {{--                </div>--}}


    {{--                <!-- HERO TEXT -->--}}
    {{--                <div class="col-md-7 col-lg-6 order-first order-md-2">--}}
    {{--                    <div class="hero-11-txt">--}}

    {{--                        <!-- Title -->--}}
    {{--                        <h2 class="h2-lg">Quark Ticari Programımızı Ücretsiz Deneyin</h2>--}}

    {{--                        <!-- Text -->--}}
    {{--                        <p class="p-xl">QR Ticari Muhasebe Programı; sağlam alt yapısı ve kullanışlı modülleri ile--}}
    {{--                            Elektrik-elektronik, telekomünikasyon, otomotiv, sigortacılık, marketler, tekstil ve--}}
    {{--                            mağazacılık, maden, inşaat, taşıma, gıda, üretim, akaryakıt vb. birçok sektöre hitap--}}
    {{--                            etmektedir.--}}
    {{--                        </p>--}}

    {{--                        <!-- DOWNLOAD BUTTON -->--}}
    {{--                        <a href="#" class="os-btn bg-white d-flex align-items-center">--}}

    {{--                            <!-- Icon -->--}}
    {{--                            <div class="os-btn-ico">--}}
    {{--                                <div class="ico-50">--}}
    {{--                                    <img src="images/png-icons/windows.png" alt="os-icon"/>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="os-btn-txt">--}}
    {{--                                <h6 class="h6-lg">Windows için indir</h6>--}}
    {{--                                <p>15 gün ücretsiz deneme</p>--}}
    {{--                            </div>--}}

    {{--                        </a>--}}

    {{--                    </div>--}}
    {{--                </div>    <!-- END HERO TEXT -->--}}


    {{--            </div>    <!-- End row -->--}}
    {{--        </div>       <!-- End container -->--}}
    {{--    </section>    <!-- END HERO-11 -->--}}




    <section id="content-1" class="content-1 bg-snow wide-60 content-section division">
        <div class="container">
            <div class="row d-flex align-items-center">


    <!-- SECTION TITLE -->
    <div class="row justify-content-center">
        <div class="col-lg-10 col-xl-8">
            <div class="section-title title-01 mb-70">

                <!-- Title -->
                <h2 class="h2-md" class="row justify-content-center">20 Yıllık Tecrübe!</h2>

                <!-- Text -->
                <p class="p-xl">Qr ürünleri bir Selçuk Teknokent Projesi olup Qr'nin 20 yıllık tecrübesinin son
                    teknolojilerle buluştuğu kolay, sade ve kullancı dostu arayüzü ile sizlere hizmet veren bir
                    teknolojik çözümdür.

                </p>

            </div>
        </div>
    </div>
            </div>
        </div>
    </section>




    <!-- CONTENT-3
    ============================================= -->
    <section id="content-3" class="content-3 wide-60 content-section division">
        <div class="container">


            <!-- TOP ROW -->
            <div class="top-row pb-50">
                <div class="row d-flex align-items-center">


                    <!-- TEXT BLOCK -->
                    <div class="col-md-7 col-lg-6 order-last order-lg-2">
                        <div class="txt-block left-column wow fadeInRight">

                            <!-- Section ID -->
                            <span class="section-id rounded-id bg-tra-purple purple-color txt-upcase">
						 				E-Fatura & E-Arşiv & E-İrsaliye & E-Defter & E-Makbuz
						 			</span>

                            <!-- Title -->
                            <h2 class="h2-xs">E-Dönüşüm Paketlerimiz
                            </h2>

                            <!-- Text -->
                            <p class="p-lg">E-Dönüşüm, bilginin, değerin, varlığın, girişimciliğin ve ihtiyaçların
                                dijital dünyada gerçekleştirilmesi ve hız ile tasarrafun temel bir ihtiyaca
                                evrilmesidir.
                            </p>

                        </div>
                    </div>    <!-- END TEXT BLOCK -->


                    <!-- IMAGE BLOCK -->
                    <div class="col-md-5 col-lg-6 order-first order-md-2">
                        <div class="img-block left-column wow fadeInLeft">
                            <a href="{{route('blog',["id"=>3])}}"><img class="img-fluid" src="images/edonusum/edonusumall.webp" alt="content-image"></a>
                        </div>
                    </div>


                </div>
            </div>    <!-- END TOP ROW -->

            <!-- DIVIDER LINE -->
            <hr class="divider">


            {{--            <!-- BOTTOM ROW -->--}}
            {{--            <div class="bottom-row">--}}
            {{--                <div class="bottom-row">--}}
            {{--                    <div class="row d-flex align-items-center">--}}


            {{--                        <!-- IMAGE BLOCK -->--}}
            {{--                        <div class="col-md-5 col-lg-6">--}}
            {{--                            <div class="img-block left-column wow fadeInRight">--}}
            {{--                                <img class="img-fluid" src="images/img-09.png" alt="video-preview">--}}
            {{--                            </div>--}}
            {{--                        </div>--}}


            {{--                        <!-- TEXT BLOCK -->--}}
            {{--                        <div class="col-md-7 col-lg-6">--}}
            {{--                            <div class="txt-block right-column wow fadeInLeft">--}}

            {{--                                <!-- TEXT BOX -->--}}
            {{--                                <div class="txt-box mb-20">--}}

            {{--                                    <!-- Title -->--}}
            {{--                                    <h5 class="h5-lg">Advanced Performance Made Easy</h5>--}}

            {{--                                    <!-- Text -->--}}
            {{--                                    <p class="p-lg">Quaerat sodales sapien euismod blandit at vitae ipsum primis undo--}}
            {{--                                        and--}}
            {{--                                        cubilia laoreet augue and luctus magna dolor luctus at egestas sapien vitae nemo--}}
            {{--                                        egestas--}}
            {{--                                        volute and turpis dolores aliquam quaerat sodales a sapien--}}
            {{--                                    </p>--}}

            {{--                                </div>--}}

            {{--                                <!-- TEXT BOX -->--}}
            {{--                                <div class="txt-box">--}}

            {{--                                    <!-- Title -->--}}
            {{--                                    <h5 class="h5-lg">Manage Your Workflow Easily</h5>--}}

            {{--                                    <!-- List -->--}}
            {{--                                    <ul class="simple-list">--}}

            {{--                                        <li class="list-item">--}}
            {{--                                            <p class="p-lg">Fringilla risus, luctus mauris auctor euismod an iaculis--}}
            {{--                                                luctus--}}
            {{--                                                magna purus pretium ligula purus and quaerat--}}
            {{--                                            </p>--}}
            {{--                                        </li>--}}

            {{--                                        <li class="list-item">--}}
            {{--                                            <p class="p-lg">Nemo ipsam egestas volute turpis dolores undo ultrice--}}
            {{--                                                aliquam--}}
            {{--                                                quaerat--}}
            {{--                                                at sodales sapien purus--}}
            {{--                                            </p>--}}
            {{--                                        </li>--}}

            {{--                                    </ul>--}}

            {{--                                </div>    <!-- END TEXT BOX -->--}}

            {{--                            </div>--}}
            {{--                        </div>    <!-- END TEXT BLOCK -->--}}


            {{--                    </div>--}}
            {{--                </div>    <!-- END BOTTOM ROW -->--}}


        </div>       <!-- End container -->
        </div>
    </section>    <!-- END CONTENT-3 -->




    <!-- CONTENT-9
    ============================================= -->
    {{--    <section id="content-9" class="content-9 bg-04 pt-100 content-section division">--}}
    {{--        <div class="container white-color">--}}


    {{--            <!-- SECTION TITLE -->--}}
    {{--            <div class="row justify-content-center">--}}
    {{--                <div class="col-md-10 col-lg-8">--}}
    {{--                    <div class="section-title title-02 mb-60">--}}

    {{--                        <!-- Section ID -->--}}
    {{--                        <span class="section-id rounded-id bg-tra-white white-color txt-upcase">--}}
    {{--					 				Extremely Flexible--}}
    {{--					 			</span>--}}

    {{--                        <!-- Title -->--}}
    {{--                        <h2 class="h2-xs">Discover powerful features to boost your productivity</h2>--}}

    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>--}}


    {{--            <!-- IMAGE BLOCK -->--}}
    {{--            <div class="row">--}}
    {{--                <div class="col">--}}
    {{--                    <div class="content-9-img video-preview wow fadeInUp">--}}

    {{--                        <!-- Play Icon -->--}}
    {{--                        <a class="video-popup1" href="https://www.youtube.com/embed/SZEflIVnhH8">--}}
    {{--                            <div class="video-btn video-btn-xl bg-pink ico-90">--}}
    {{--                                <div class="video-block-wrapper"><span class="flaticon-play-button"></span></div>--}}
    {{--                            </div>--}}
    {{--                        </a>--}}

    {{--                        <!-- Preview Image -->--}}
    {{--                        <img class="img-fluid" src="images/dashboard-07.png" alt="video-preview">--}}

    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>--}}


    {{--        </div>       <!-- End container -->--}}
    {{--    </section>    <!-- END CONTENT-9 -->--}}




    <!-- FEATURES-4
    ============================================= -->
    <section id="features-4" class="wide-60 features-section division">
        <div class="container">


            <!-- FEATURES-4 WRAPPER -->
            <div class="fbox-4-wrapper fbox-4-wide">
                <div class="row row-cols-1 row-cols-md-2">


                    <!-- FEATURE BOX #1 -->
                    <div class="col">
                        <div class="fbox-4 pr-25 mb-40 wow fadeInUp">

                            <!-- Icon -->
                            <div class="fbox-ico">
                                <div class="fbox-ico-center ico-65">
                                    <span class="flaticon-dashboard"></span>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="fbox-txt">

                                <!-- Title -->
                                <h5 class="h5-md">Kullanıcı Dostu Arayüz</h5>

                                <!-- Text -->
                                <p class="p-lg">QR ürünleri, kolay erişilebilir sekmeler, göz yormayan bir tema ve
                                    kullanıcının
                                    nerede ne bulabileceğini kolaylıkla görebilmesi için tasarlanmıştır.
                                </p>

                            </div>

                        </div>
                    </div>


                    <!-- FEATURE BOX #2 -->
                    <div class="col">
                        <div class="fbox-4 pl-25 mb-40 wow fadeInUp">

                            <!-- Icon -->
                            <div class="fbox-ico">
                                <div class="fbox-ico-center ico-65">
                                    <span class="flaticon-pantone"></span>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="fbox-txt">

                                <!-- Title -->
                                <h5 class="h5-md">Güçlü Seçenekler</h5>

                                <!-- Text -->
                                <p class="p-lg">Kendine özgü arayüzüyle, kolay entegreli, kişiselleştirebilir ve modüler
                                    yapısıyla Qr ürünleri kullanıma hazırdır.
                                </p>

                            </div>

                        </div>
                    </div>


                    <!-- FEATURE BOX #3 -->
                    <div class="col">
                        <div class="fbox-4 pr-25 mb-40 wow fadeInUp">

                            <!-- Icon -->
                            <div class="fbox-ico">
                                <div class="fbox-ico-center ico-65">
                                    <span class="flaticon-folder-3"></span>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="fbox-txt">

                                <!-- Title -->
                                <h5 class="h5-md">Dosya Yöneticisi</h5>

                                <!-- Text -->
                                <p class="p-lg">Microsoft Office programlarının formatları
                                    (Excel, Word, Powerpoint vs), Pdf, Resim Formatları, dosyalarınızdaki bilgilerinizi
                                    kolayca Qr ürünlerimize entegreli çalışmaktadır.
                                </p>

                            </div>

                        </div>
                    </div>


                    <!-- FEATURE BOX #4 -->
                    <div class="col">
                        <div class="fbox-4 pl-25 mb-40 wow fadeInUp">

                            <!-- Icon -->
                            <div class="fbox-ico">
                                <div class="fbox-ico-center ico-65">
                                    <span class="flaticon-resize"></span>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="fbox-txt">

                                <!-- Title -->
                                <h5 class="h5-md">Entegreli Çalışan Mobil Uygulama</h5>

                                <!-- Text -->
                                <p class="p-lg">Android ve windows cihazlarında(telefon, tablet) kullanılan Quark Mobil
                                    programı, Quark Ticari ön muhasebe programı ile online ve offline ortamlarda
                                    entegreli olarak çalışmaktadır.
                                </p>

                            </div>

                        </div>
                    </div>


                    <!-- FEATURE BOX #5 -->
                    <div class="col">
                        <div class="fbox-4 pr-25 mb-40 wow fadeInUp">

                            <!-- Icon -->
                            <div class="fbox-ico">
                                <div class="fbox-ico-center ico-65">
                                    <span class="flaticon-share"></span>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="fbox-txt">

                                <!-- Title -->
                                <h5 class="h5-md">Excel Dökümü</h5>

                                <!-- Text -->
                                <p class="p-lg">Fatura, Fiş, İrsaliye, Tahakkuk, Teklif, Banka, Kredi Kartı, Personel
                                    hareket, Üretim, Teknik servis, Vergi dairesi cetvelini, Örgüt bazında süt
                                    analizi, Müstahsil makbuz listesini, Araç listesini vb. raporlarınızı kolayca excel
                                    formatında indirebilir ve düzenleyebilirsiniz.
                                </p>

                            </div>

                        </div>
                    </div>


                    <!-- FEATURE BOX #6 -->
                    <div class="col">
                        <div class="fbox-4 pl-25 mb-40 wow fadeInUp">

                            <!-- Icon -->
                            <div class="fbox-ico">
                                <div class="fbox-ico-center ico-65">
                                    <span class="flaticon-layers"></span>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="fbox-txt">

                                <!-- Title -->
                                <h5 class="h5-md">Modüller ve Eklentiler</h5>

                                <!-- Text -->
                                <p class="p-lg">Hazır Modüler yapımızla şirketinize göre kişiselleştirebilir ve
                                    kendinize özgü arayüz oluşturabilirsiniz.
                                </p>

                            </div>

                        </div>
                    </div>


                </div>
            </div>    <!-- END FEATURES-4 WRAPPER -->


        </div>     <!-- End container -->
    </section>    <!-- END FEATURES-4 -->




    <!-- DIVIDER LINE -->
    <hr class="divider">

    <!-- Title -->
    <div class="container">

        <!-- Quark Ticari
        ============================================= -->
        <section id="content-7" class="content-7 wide-60 content-section division">
            <div class="container">
                <div class="row d-flex align-items-center">


                    <!-- TEXT BLOCK -->
                    <div class="col-md-6 order-last order-md-2">
                        <div class="txt-block right-column wow fadeInRight">

                            <!-- TEXT BOX -->
                            <div class="txt-box mb-25">

                                <!-- Title -->
                                <h5 class="h5-lg">Quark Ticari </h5>

                                <!-- Text -->
                                <p class="p-lg">Quark Ticari Muhasebe Programı; sağlam alt yapısı ve kullanışlı modülleri ile Elektrik-elektronik, telekomünikasyon, otomotiv, sigortacılık, marketler, tekstil ve mağazacılık, maden, inşaat, taşıma, gıda, üretim, akaryakıt vb. birçok sektöre hitap etmektedir.
                                </p>

                            </div>

                            <!-- TEXT BOX -->
                            <div class="txt-box">

                                <!-- Title -->
                                <h5 class="h5-lg">Modüller</h5>

                                <!-- List -->
                                <ul class="simple-list">

                                    <li class="list-item">
                                        <p class="p-lg">Şube Sistemi, Cari, Stok, Kasa, Fatura, İrsaliye, Tahakkuk, Fiş,
                                            Teklif, Banka, Kredi Kartı, Çek, Senet, Basit Üretim, Proje, Teknik Servis,
                                            Araç Takip, Sözleşme, Pompa İşlemleri, Hızlı Satış, Müstahsil, Araç Takibi, Taksit ve
                                            Kullanıcı İşlemleri.

                                        </p>
                                    </li>

                                    <li class="list-item">
                                        <p class="p-lg">Genel Raporlama çeşitleri
                                        </p>
                                    </li>
                                    <a href="{{route("demoindir")}}" class="btn btn-red tra-grey-hover last-link">Quark Ticari'yi Deneyin</a>

                                </ul>

                            </div>    <!-- END TEXT BOX -->

                        </div>
                    </div>    <!-- END TEXT BLOCK -->


                    <!-- IMAGE BLOCK -->
                    <div class="col-md-6 order-first order-md-2">
                        <div class="content-7-img wow fadeInRight">
                            <a href="{{route("urungetir",["id"=>1])}}"><img class="img-fluid" src="images/qrticari.webp" alt="content-image"></a>
                        </div>
                    </div>


                </div>      <!-- End row -->
            </div>       <!-- End container -->
        </section>    <!-- END CONTENT-7 -->


        <!-- Quark Pos
        ============================================= -->
        <section id="content-7" class="content-7 wide-60 content-section division">
            <div class="container">
                <div class="row d-flex align-items-center">


                    <!-- TEXT BLOCK -->
                    <div class="col-md-6 order-last order-md-2">
                        <div class="txt-block right-column wow fadeInRight">

                            <!-- TEXT BOX -->
                            <div class="txt-box mb-25">

                                <!-- Title -->
                                <h5 class="h5-lg">Quark (Pos) Hızlı Satış </h5>

                                <!-- Text -->
                                <p class="p-lg">QUARK Hızlı Satış (Pos) Otomasyonu sizi büyük bir yükten kurtarmak için
                                    göreve hazır. Quark Pos Satış Yazılımı, sıcak satış yapan marketler, toptancılar,
                                    kırtasiyeler, bakkallar, petrol istasyonları vb. birçok işletme için tasarlanmıştır.
                                </p>

                            </div>

                            <!-- TEXT BOX -->
                            <div class="txt-box">

                                <!-- Title -->
                                <h5 class="h5-lg">Modüller</h5>

                                <!-- List -->
                                <ul class="simple-list">

                                    <li class="list-item">
                                        <p class="p-lg">
                                            Satış Ekranı, Kasiyer, Cari, Stok, Kasa, Fatura, Fiş, ID Caller, Terazi ve Quark Ticari ile entegreli.
                                        </p>
                                    </li>
                                    <a href="{{route("demoindir")}}" class="btn btn-red tra-grey-hover last-link">Quark Pos'u Deneyin</a>
                                </ul>

                            </div>    <!-- END TEXT BOX -->

                        </div>
                    </div>    <!-- END TEXT BLOCK -->


                    <!-- IMAGE BLOCK -->
                    <div class="col-md-6 order-first order-md-2">
                        <div class="content-7-img wow fadeInRight">
                            <a href="{{route("urungetir",["id"=>2])}}"><img class="img-fluid" src="images/qrpos.webp" alt="content-image"></a>
                        </div>
                    </div>


                </div>      <!-- End row -->
            </div>       <!-- End container -->
        </section>    <!-- END CONTENT-7 -->

    </div>

    <!-- DIVIDER LINE -->
    <hr class="divider">



    <!-- CONTENT-5
    ============================================= -->
    <section id="content-5" class="content-5 ws-wrapper content-section division">
        <div class="container">
            <div class="content-5-wrapper bg-whitesmoke">
                <div class="row d-flex align-items-center">


                    <!-- TEXT BLOCK -->
                    <div class="col-md-7 col-lg-6">
                        <div class="txt-block left-column wow fadeInRight">

                            <!-- Section ID -->
                            <span class="section-id rounded-id bg-tra-purple purple-color txt-upcase">
						 				Quark Mobil
						 			</span>

                            <!-- Title -->
                            <h2 class="h2-xs">Entegreli Quark Mobil </h2>

                            <!-- List -->
                            <ul class="simple-list">
                                <li class="list-item">
                                    <p class="p-lg">Quark Ticari programıyla internetli ve internetsiz ortamlarda
                                        farketmeksizin
                                        veri girişlerinizi kolayca yapabilirsiniz.
                                    </p>
                                </li>

                                <li class="list-item">
                                    <p class="p-lg">Sıcak Satış: Araçta fatura keserek satış</p>
                                </li>

                                <li class="list-item">
                                    <p class="p-lg">Soğuk Satış: Saha elemanı ile sipariş alımı
                                    </p>
                                </li>

                                <li class="list-item">
                                    <p class="p-lg">Mobil Tahsilat: Sahadan yapılan tahsilatların takibi
                                    </p>
                                </li>

                                <li class="list-item">
                                    <p class="p-lg">Mobil Ödeme: Sahada yapılan ödemelerin takibi
                                    </p>
                                </li>

                                <li class="list-item">
                                    <p class="p-lg">Cari: Cari bakiye ve ekstresinin kontrolü
                                    </p>
                                </li>

                                <li class="list-item">
                                    <p class="p-lg">Fiyat Gör: Satış esnasında kod üzerinden stok fiyat inceleme
                                    </p>
                                </li>
                                <a href="{{route("iletisim")}}"><button type="button" class="btn btn-red tra-grey-hover last-link" data-toggle="99modal" data-target="#exampleModalLong">
                                        Deneyimlemek için İletişime Geçin</button></a>
                            </ul>

                        </div>
                    </div>    <!-- END TEXT BLOCK -->


                    <!-- IMAGE BLOCK -->
                    <div class="col-md-5 col-lg-6">
                        <div class="img-block right-column wow fadeInLeft">
                            <a href="{{route("urungetir",["id"=>4])}}"> <img class="img-fluid" src="images/img-10.webp" alt="Quark Mobil Ekran Görüntüsü"></a>
                        </div>
                    </div>


                </div>
            </div>    <!-- End row -->
        </div>       <!-- End container -->
    </section>    <!-- END CONTENT-5 -->




    {{--    <!-- FEATURES-8--}}
    {{--    ============================================= -->--}}
    {{--    <section id="features-8" class="wide-60 features-section division">--}}
    {{--        <div class="container">--}}


    {{--            <!-- SECTION TITLE -->--}}
    {{--            <div class="row justify-content-center">--}}
    {{--                <div class="col-lg-10 col-xl-8">--}}
    {{--                    <div class="section-title title-01 mb-70">--}}

    {{--                        <!-- Title -->--}}
    {{--                        <h2 class="h2-md">We’re Better. Here’s Why…</h2>--}}

    {{--                        <!-- Text -->--}}
    {{--                        <p class="p-xl">Aliquam a augue suscipit, luctus neque purus ipsum neque dolor primis a libero--}}
    {{--                            tempus, blandit and cursus varius and magnis sapien--}}
    {{--                        </p>--}}

    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>--}}


    {{--            <!-- FEATURES-8 WRAPPER -->--}}
    {{--            <div class="fbox-8-wrapper text-center">--}}
    {{--                <div class="row row-cols-1 row-cols-md-3">--}}


    {{--                    <!-- FEATURE BOX #1 -->--}}
    {{--                    <div class="col">--}}
    {{--                        <div class="fbox-8 mb-40 wow fadeInUp">--}}

    {{--                            <!-- Image -->--}}
    {{--                            <div class="fbox-img bg-whitesmoke-gradient">--}}
    {{--                                <img class="img-fluid" src="images/img-22.png" alt="feature-icon"/>--}}
    {{--                            </div>--}}

    {{--                            <!-- Title -->--}}
    {{--                            <h5 class="h5-md">Extremely Flexible</h5>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <p class="p-lg">Feugiat primis ultrice semper lacus cursus feugiat undo primis ultrice a--}}
    {{--                                ligula an auctor tempus magnis--}}
    {{--                            </p>--}}

    {{--                        </div>--}}
    {{--                    </div>--}}


    {{--                    <!-- FEATURE BOX #2 -->--}}
    {{--                    <div class="col">--}}
    {{--                        <div class="fbox-8 mb-40 wow fadeInUp">--}}

    {{--                            <!-- Image -->--}}
    {{--                            <div class="fbox-img bg-whitesmoke-gradient">--}}
    {{--                                <img class="img-fluid" src="images/img-24.png" alt="feature-icon"/>--}}
    {{--                            </div>--}}

    {{--                            <!-- Title -->--}}
    {{--                            <h5 class="h5-md">Easy To Cusomize</h5>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <p class="p-lg">Feugiat primis ultrice semper lacus cursus feugiat undo primis ultrice a--}}
    {{--                                ligula an auctor tempus magnis--}}
    {{--                            </p>--}}

    {{--                        </div>--}}
    {{--                    </div>--}}


    {{--                    <!-- FEATURE BOX #3 -->--}}
    {{--                    <div class="col">--}}
    {{--                        <div class="fbox-8 mb-40 wow fadeInUp">--}}

    {{--                            <!-- Image -->--}}
    {{--                            <div class="fbox-img bg-whitesmoke-gradient">--}}
    {{--                                <img class="img-fluid" src="images/img-23.png" alt="feature-icon"/>--}}
    {{--                            </div>--}}

    {{--                            <!-- Title -->--}}
    {{--                            <h5 class="h5-md">Concrete Security</h5>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <p class="p-lg">Feugiat primis ultrice semper lacus cursus feugiat undo primis ultrice a--}}
    {{--                                ligula an auctor tempus magnis--}}
    {{--                            </p>--}}

    {{--                        </div>--}}
    {{--                    </div>--}}


    {{--                </div>  <!-- End row -->--}}
    {{--            </div>    <!-- END FEATURES-8 WRAPPER -->--}}


    {{--        </div>       <!-- End container -->--}}
    {{--    </section>    <!-- END FEATURES-8 -->--}}




    <!-- TESTIMONIALS-1
    ============================================= -->
    {{--    <section id="reviews-1" class="bg-whitesmoke-gradient wide-100 reviews-section division">--}}
    {{--        <div class="container">--}}


    {{--            <!-- SECTION TITLE -->--}}
    {{--            <div class="row justify-content-center">--}}
    {{--                <div class="col-lg-10 col-xl-8">--}}
    {{--                    <div class="section-title title-01 mb-70">--}}

    {{--                        <!-- Title -->--}}
    {{--                        <h2 class="h2-md">Stories From Our Customers</h2>--}}

    {{--                        <!-- Text -->--}}
    {{--                        <p class="p-xl">Aliquam a augue suscipit, luctus neque purus ipsum neque dolor primis a libero--}}
    {{--                            tempus, blandit and cursus varius and magnis sapien--}}
    {{--                        </p>--}}

    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>--}}


    {{--            <!-- TESTIMONIALS CONTENT -->--}}
    {{--            <div class="row">--}}
    {{--                <div class="col">--}}
    {{--                    <div class="owl-carousel owl-theme reviews-1-wrapper">--}}


    {{--                        <!-- TESTIMONIAL #1 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">Etiam sapien sagittis congue augue massa varius egestas ultrice--}}
    {{--                                    varius magna a tempus aliquet undo cursus suscipit--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-1.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Scott Boxer</h6>--}}
    {{--                                        <p class="p-md">@scott_boxer</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #1 -->--}}


    {{--                        <!-- TESTIMONIAL #2 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">At sagittis congue augue and egestas magna ipsum vitae a purus ipsum--}}
    {{--                                    primis in cubilia laoreet augue egestas luctus and donec diam ultrice ligula magna--}}
    {{--                                    suscipit lectus gestas augue into cubilia--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-2.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Joel Peterson</h6>--}}
    {{--                                        <p class="p-md">Internet Surfer</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #2 -->--}}


    {{--                        <!-- TESTIMONIAL #3 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">Mauris donec magnis sapien etiam sapien congue augue egestas et ultrice--}}
    {{--                                    vitae purus diam integer a congue magna ligula undo egestas magna at suscipit--}}
    {{--                                    feugiat--}}
    {{--                                    primis--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-3.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Marisol19</h6>--}}
    {{--                                        <p class="p-md">@marisol19</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #3 -->--}}


    {{--                        <!-- TESTIMONIAL #4 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">Mauris donec a magnis sapien etiam sapien congue augue pretium ligula--}}
    {{--                                    lectus aenean a magna undo mauris lectus laoreet tempor egestas--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-4.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Leslie D.</h6>--}}
    {{--                                        <p class="p-md">Web Developer</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #4 -->--}}


    {{--                        <!-- TESTIMONIAL #5 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">An augue cubilia laoreet magna suscipit egestas and ipsum a lectus purus--}}
    {{--                                    ipsum--}}
    {{--                                    primis and augue ultrice ligula and egestas a suscipit lectus gestas undo auctor--}}
    {{--                                    tempus--}}
    {{--                                    feugiat impedit--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-5.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Jennifer Harper</h6>--}}
    {{--                                        <p class="p-md">App Developer</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #5 -->--}}


    {{--                        <!-- TESTIMONIAL #6 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">An augue cubilia laoreet undo magna ipsum semper suscipit egestas magna--}}
    {{--                                    ipsum ligula a vitae purus and ipsum primis cubilia magna suscipit--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-6.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Jonathan Barnes</h6>--}}
    {{--                                        <p class="p-md">jQuery Programmer</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #6 -->--}}


    {{--                        <!-- TESTIMONIAL #7 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">Augue egestas diam tempus volutpat egestas augue in cubilia laoreet--}}
    {{--                                    magna--}}
    {{--                                    suscipit luctus dolor and blandit vitae purus diam tempus an aliquet porta rutrum--}}
    {{--                                    gestas--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-7.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Mike Harris</h6>--}}
    {{--                                        <p class="p-md">Graphic Designer</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #7 -->--}}


    {{--                        <!-- TESTIMONIAL #8 -->--}}
    {{--                        <div class="review-1">--}}

    {{--                            <!-- Quote Icon -->--}}
    {{--                            <div class="review-1-ico ico-25">--}}
    {{--                                <span class="flaticon-left-quote"></span>--}}
    {{--                            </div>--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="review-1-txt">--}}

    {{--                                <!-- Text -->--}}
    {{--                                <p class="p-lg">Augue at vitae purus tempus egestas volutpat augue undo cubilia laoreet--}}
    {{--                                    magna suscipit luctus dolor blandit at purus tempus feugiat impedit--}}
    {{--                                </p>--}}

    {{--                                <!-- Testimonial Author -->--}}
    {{--                                <div class="author-data clearfix">--}}

    {{--                                    <!-- Testimonial Avatar -->--}}
    {{--                                    <div class="review-avatar">--}}
    {{--                                        <img src="images/review-author-8.jpg" alt="review-avatar">--}}
    {{--                                    </div>--}}

    {{--                                    <!-- Testimonial Author -->--}}
    {{--                                    <div class="review-author">--}}

    {{--                                        <h6 class="h6-xl">Evelyn Martinez</h6>--}}
    {{--                                        <p class="p-md">WordPress Consultant</p>--}}

    {{--                                        <!-- Rating -->--}}
    {{--                                        <div class="review-rating ico-15 yellow-color">--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-1"></span>--}}
    {{--                                            <span class="flaticon-star-half-empty"></span>--}}
    {{--                                        </div>--}}

    {{--                                    </div>--}}

    {{--                                </div>    <!-- End Testimonial Author -->--}}

    {{--                            </div>    <!-- End Text -->--}}

    {{--                        </div>    <!-- END TESTIMONIAL #8 -->--}}


    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>    <!-- END TESTIMONIALS CONTENT -->--}}


    {{--        </div>     <!-- End container -->--}}
    {{--    </section>    <!-- END TESTIMONIALS-1 -->--}}




    <!-- BRANDS-2
    ============================================= -->
    <br>
    <br>
    <br>

    @include('front.tekparca.referansparca')




    <!-- STATISTIC-2
    ============================================= -->
    <section id="statistic-2" class="wide-60 statistic-section division">
        <div class="container">
            <div class="row d-flex align-items-center">


                <!-- TEXT BLOCK -->
                <div class="col-lg-6">
                    <div class="txt-block right-column mb-40 wow fadeInLeft">
                        <h3 class="h3-xs">Quark Ticari, Hızlı Satış, Mobil, Sulama ve İşçi Maaşı yazılımlarımızı aktif
                            olarak 2000'den fazla firma kullanmaktadır.</h3>
                    </div>
                </div>


                <!-- STATISTIC BLOCK #1 -->
                <div class="col-sm-5 col-md-4 col-lg-3 offset-sm-1 offset-md-2 offset-lg-1">
                    <div class="statistic-block wow fadeInUp">

                        <!-- Text -->
                        <h2 class="h2-title-xs statistic-number"><span class="count-element">5000</span>+</h2>
                        <p class="p-lg mt-20">Toplam kullanıcı <br/> sayısı</p>

                    </div>
                </div>


                <!-- STATISTIC BLOCK #2 -->
                <div class="col-sm-5 col-md-4 col-lg-2">
                    <div class="statistic-block wow fadeInUp">

                        <!-- Text -->
                        <h2 class="h2-title-xs statistic-number">
                            <span class="count-element">4</span>.<span class="count-element">86</span>
                        </h2>

                        <!-- Rating -->
                        <div class="txt-block-rating ico-15 yellow-color">
                            <span class="flaticon-star-1"></span>
                            <span class="flaticon-star-1"></span>
                            <span class="flaticon-star-1"></span>
                            <span class="flaticon-star-1"></span>
                            <span class="flaticon-star-half-empty"></span>
                        </div>

                        <p class="p-lg txt-400">1,256 Geri Dönüş</p>
                    </div>
                </div>


            </div>    <!-- End row -->
        </div>       <!-- End container -->
    </section>    <!-- END STATISTIC-2 -->




    <!-- DIVIDER LINE -->
    <hr class="divider">




    <!-- FAQs-2
    ============================================= -->
    <section id="faqs-2" class="wide-60 faqs-section division">
        <div class="container">


            <!-- SECTION TITLE -->
            <div class="row justify-content-center">
                <div class="col-lg-10 col-xl-8">
                    <div class="section-title title-01 mb-80">

                        <!-- Title -->
                        <h2 class="h2-md">Sorunuz Var Mı?</h2>

                        <!-- Text -->
                        <p class="p-xl">Popüler soruların cevapları aşağıdadır eğer sizin sorunuz aşağıda yoksa aşağıda
                            sorunuzu buradan sorabilirsiniz diyerek bizimle iletişime geçebilirsiniz.
                        </p>

                    </div>
                </div>
            </div>


            <!-- FAQs-2 QUESTIONS -->
            <div class="faqs-2-questions">
                <div class="row row-cols-1 row-cols-lg-2">


                    <!-- QUESTIONS HOLDER -->
                    <div class="col">
                        <div class="questions-holder pr-15">


                            <!-- QUESTION #1 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Lisans yenilemesi nasıl yapabilirim?</h5>

                                <!-- Answer -->
                                <p class="p-lg">0850 302 16 05 telefon numarasında veya iletişim bölümünden kayıt
                                    oluşturmanız gerekmektedir.
                                </p>

                            </div>


                            <!-- QUESTION #2 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Quark ürünlerine nasıl sahip olabilirim?</h5>

                                <!-- Answer -->
                                <p class="p-lg">Anlaşmalı bayilerimizden veya internet ortamından lisans temin edebilirsiniz.
                                </p>

                            </div>


                            <!-- QUESTION #3 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Quark ürününü nasıl iade edebilirim?</h5>

                                <!-- Answer -->
                                <ul class="simple-list">

                                    <li class="list-item">
                                        <p class="p-lg">Lisanslanabilir ürünlerimizde iade işlemi yapılamaz.
                                        </p>
                                    </li>
                                    <li class="list-item">
                                        <p class="p-lg">QR Yazılım tarafından almış olduğunuz ürün parçlarını 7
                                            gün iş günü içinde iade edebilirsiniz.
                                        </p>
                                    </li>

                                </ul>

                            </div>

                            <!-- QUESTION #3 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Quark ürünlerinin eğitimini nasıl alırım?</h5>

                                <!-- Answer -->
                                <ul class="simple-list">

                                    <li class="list-item">
                                        <p class="p-lg">0850 302 16 05 telefon numarasında veya iletişim bölümünden kayıt
                                            oluşturmanız gerekmektedir.
                                        </p>
                                    </li>


                                </ul>

                            </div>


                        </div>
                    </div>    <!-- END QUESTIONS HOLDER -->


                    <!-- QUESTIONS HOLDER -->
                    <div class="col">
                        <div class="questions-holder pl-15">


                            <!-- QUESTION #4 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Ücretsiz Deneme Sürümü Kullanabilir miyim?</h5>

                                <!-- Answer -->
                                <p class="p-lg">Evet istediğin modülü süre kısıtlamaksızın işlem sayısı limiti ile indirebilirsiniz
                                </p>

                            </div>


                            <!-- QUESTION #5 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Yurtdışına proje geliştirip yazmakta mısınız?</h5>

                                <!-- Answer -->
                                <p class="p-lg">Evet.
                                </p>


                            </div>


                            <!-- QUESTION #6 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Quark ürünleri internetsiz ortamda çalışıyor mu?</h5>

                                <!-- Answer -->
                                <ul class="simple-list">

                                    <li class="list-item">
                                        <p class="p-lg">Evet programın çalışabilmesi için internete gerek yok</p>
                                    </li>

                                    <li class="list-item">
                                        <p class="p-lg">Verilerinizi ister buluta ister veri yedekleme cihazlarına
                                            yedekleme seçeneği mevcuttur.
                                        </p>
                                    </li>

                                </ul>

                            </div> <!-- QUESTION #6 -->
                            <div class="question wow fadeInUp">

                                <!-- Question -->
                                <h5 class="h5-md">Özel yazılımlar gerçekleştiriyor musunuz?</h5>

                                <!-- Answer -->
                                <ul class="simple-list">

                                    <li class="list-item">
                                        <p class="p-lg">Evet. Sizden gelen fikirleri değerlendirip sizlerle beraber
                                            projeleri gerçekleştiriyoruz</p>
                                    </li>


                                </ul>

                            </div>


                        </div>
                    </div>    <!-- END QUESTIONS HOLDER -->


                </div>    <!-- End row -->
            </div>    <!-- END FAQs-2 QUESTIONS -->


            <!-- MORE QUESTIONS BUTTON -->
            <div class="row">
                <div class="col">
                    <div class="more-questions">
                        <h5 class="h5-sm">Sorunuz mu var? <a href="{{route("iletisim")}}">Sorunuzu buradan
                                sorabilirsiniz.</a></h5>
                    </div>
                </div>
            </div>


        </div>       <!-- End container -->
    </section>    <!-- END FAQs-2 -->




    <!-- CALL TO ACTION-9
    ============================================= -->
    <section id="cta-9" class="bg-tra-purple wide-80 cta-section division">
        <div class="container">
            <div class="row justify-content-md-center">


                <!-- CALL TO ACTION TEXT -->
                <div class="col col-lg-8">
                    <div class="cta-9-txt text-center">

                        <!-- Title -->
                        <h2 class="h2-xs">Deneme Sürümünü İndirin</h2>
                        <p class="p-xl mb-35">Programlarımız süresiz olup işlem limiti ile deneyebilirsiniz.</p>

                        <!-- DOWNLOAD BUTTON -->
                        <a href="{{route('demoindir')}}" class="os-btn bg-white d-flex align-items-center">

                            <!-- Icon -->
                            <div class="os-btn-ico">
                                <div class="ico-50">
                                    <img src="images/png-icons/windows.png" alt="os-icon"/>
                                </div>
                            </div>

                            <!-- Text -->
                            <div class="os-btn-txt">
                                <h6 class="h6-lg">Windows için indir</h6>
                                <p>Ücretsiz Deneyin</p>
                            </div>

                        </a>


                    </div>
                </div>    <!-- END CALL TO ACTION TEXT -->


            </div>    <!-- End row -->
        </div>       <!-- End container -->
    </section>    <!-- END CALL TO ACTION-9 -->

@endsection
@section('css')

@endsection


@section('js')
   <script>
       var myModal = document.getElementById('modal')
       var myInput = document.getElementById('myInput')

       myModal.addEventListener('shown.bs.modal', function () {
           myInput.focus()
       })
   </script>
@endsection
