@extends('front.layouts.master')
@section('title','İletişim - QR Yazılım')
@section('menustyle','dark')
@section('content')


    <section id="contacts-2" class="bg-snow wide-50 inner-page-hero contacts-section division">
        <div class="container">


            <!-- SECTION TITLE -->
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8">
                    <div class="section-title title-02 mb-80">
                        @if(session('doneMessage'))
                            <div class="alert alert-success">{{session('doneMessage')}}
                            </div>
                        @endif

                        <!-- Title -->
                        <h3 class="h3-xl">Bizimle İletişime Geçin</h3>

                        <!-- Text -->
                        <p class="p-xl">İletişim Bilgilerimizi Kullanarak Her Türlü İstek ve İhtiyaçlarınızı Bize
                            Bildirebilirsiniz
                        </p>

                    </div>
                </div>
            </div>


            <!-- CONTACT FORM -->
            <div class="row justify-content-center">
                <div class="col-lg-10 col-xl-8">
                    <div class="form-holder">
                        <form method="post" id="form_validation" class="row contact-form" type="submit"
                              action="{{ route('iletisimsave') }}">
                        @csrf
                        <!-- Form Select -->
                        {{--  <div class="col-md-12 input-subject">
                              <p class="p-lg">This question is about: </p>
                              <span>Choose a topic, so we know who to send your request to: </span>
                              <select class="form-select subject" aria-label="Default select example">
                                  <option selected>This question is about...</option>
                                  <option>Registering/Authorising</option>
                                  <option>Using Application</option>
                                  <option>Troubleshooting</option>
                                  <option>Backup/Restore</option>
                                  <option>Other</option>
                              </select>
                          </div>--}}

                        <!-- Contact Form Input -->
                            <div class="col-md-12">
                                <p class="p-lg">Ad Soyad: </p>
                                <span>Lütfen adınızı soyadınızı eksiksiz giriniz: </span>
                                <input type="text" name="adsoyad" class="form-control name" placeholder="İsminiz*"
                                       required>
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">E-Posta Adresi: </p>
                                <span>Doğruluk için lütfen e-posta adresinizi dikkatlice kontrol edin</span>
                                <input type="email" name="email" class="form-control email"
                                       placeholder="E-Posta Adresiniz*" required>
                            </div>
                            <div class="col-md-12">
                                <p class="p-lg">Konu: </p>
                                <input class="form-control" name="konu" rows="6"
                                       placeholder="">
                            </div>
                            <div class="col-md-12">
                                <p class="p-lg">Mesaj: </p>
                                <textarea class="form-control message" name="mesaj" rows="6"
                                          placeholder="..."></textarea>
                            </div>

                            <!-- Contact Form Button -->
                            <div class="col-md-12 mt-15 form-btn text-right">
                                <button type="submit" class="btn btn-skyblue tra-grey-hover submit">Cevapları Gönder
                                </button>
                            </div>

                            <!-- Contact Form Message -->
                            <div class="col-lg-12 contact-form-msg">
                                <span class="loading"></span>
                            </div>

                        </form>
                    </div>
                </div>
            </div>       <!-- END CONTACT FORM -->
            <!-- DIVIDER LINE -->
            <hr class="divider">
            <div><br></div>
            <div><br></div>
            <section id="cta-8" class="bg-snow wide-100 cta-section division">
                <div class="row mb-5">
                    <div class="col-lg-4">
                        <div class="overflow-hidden mb-3">
                            <h4 class="pt-5 mb-0 appear-animation" data-appear-animation="maskUp"
                                data-appear-animation-delay="200" data-plugin-options="{'accY': -200}">Bizimle İletişime
                                <strong>Geçin</strong></h4>
                        </div>
                        <div class="overflow-hidden mb-3">
                            <p class="lead text-4 mb-0 appear-animation" data-appear-animation="maskUp"
                               data-appear-animation-delay="400" data-plugin-options="{'accY': -200}">İletişim
                                Bilgilerimizi Kullanarak Her Türlü İstek ve İhtiyaçlarınızı Bize Bildirebilirsiniz
                            </p>
                        </div>


                    </div>
                    <div class="col-lg-4 offset-lg-1 appear-animation" data-appear-animation="fadeIn"
                         data-appear-animation-delay="800" data-plugin-options="{'accY': -200}">

                        <h4 class="pt-5">Bizim <strong>Ofisimiz</strong></h4>
                        <ul class="list list-icons list-icons-style-3 mt-2">
                            <li><i class="fas fa-map-marker-alt top-6"></i> <strong>Adres:</strong> Akademi mah. Gürkuyu
                                sok. Konya Teknokent Binası No:67/A1-316
                            </li>
                            <li><i class="fas fa-phone top-6"></i> <strong>Phone:</strong> +90(850) 302 1605 / +90(551) 047 5786</li>
                            <li><i class="fas fa-envelope top-6"></i> <strong>E-Posta Adresi:</strong> <a
                                    href="mailto:mail@example.com">bilgi@qryazilim.com</a></li>
                        </ul>

                    </div>
                    <div class="col-lg-3 appear-animation" data-appear-animation="fadeIn"
                         data-appear-animation-delay="1000"
                         data-plugin-options="{'accY': -200}">

                        <h4 class="pt-5">Çalışma <strong>Saatlerimiz</strong></h4>
                        <ul class="list list-icons list-dark mt-2">
                            <li><i class="far fa-clock top-6"></i> Hafta içi / 09:00 - 18:00</li>
                            <li><i class="far fa-clock top-6"></i> Cumartesi / 09:00 - 15:00</li>
                            <li><i class="far fa-clock top-6"></i> Pazar / Kapalı</li>
                        </ul>

                    </div>

                </div><!-- End container -->
            </section>
        </div>


    </section>
@endsection
