@extends('front.layouts.master')
@section('title','İŞ Başvurusu - QR Yazılım')
@section('menustyle','dark')
@section('content')



    <!-- CONTACTS-2
                ============================================= -->
    <section id="contacts-2" class="bg-snow wide-50 inner-page-hero contacts-section division">
        <div class="container">
            <!-- SECTION TITLE -->
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8">
                    <div class="section-title title-02 mb-80">

                        @if(session('doneBasvuruEmail'))
                            <div class="alert alert-success">{{session('doneBasvuruEmail')}}
                            </div>
                        @endif

                        <!-- Title -->
                        <h3 class="h3-xl">QR Yazılım İş Başvurusu Merkezi</h3>

                        <!-- Text -->
                        <p class="p-xl">İş başvurusu için lütfen aşağıdaki alanları eksiksiz doldurunuz.
                        </p>

                    </div>
                </div>
            </div>


            <!-- CONTACT FORM -->
            <div class="row justify-content-center">
                <div class="col-lg-10 col-xl-8">
                    <div class="form-holder">
                        <form method="post" name="contactform" type="submit" class="row contact-form"
                              action="{{ route('isbasvurususave') }}" enctype="multipart/form-data">
                        @csrf
                        <!-- Form Select -->
                        {{--  <div class="col-md-12 input-subject">
                              <p class="p-lg">This question is about: </p>
                              <span>Choose a topic, so we know who to send your request to: </span>
                              <select class="form-select subject" aria-label="Default select example">
                                  <option selected>This question is about...</option>
                                  <option>Registering/Authorising</option>
                                  <option>Using Application</option>
                                  <option>Troubleshooting</option>
                                  <option>Backup/Restore</option>
                                  <option>Other</option>
                              </select>
                          </div>--}}

                        <!-- Contact Form Input -->
                            <div class="col-md-12">
                                <p class="p-lg">Ad Soyad: </p>
                                <span>Lütfen adınızı soyadınızı eksiksiz giriniz: </span>
                                <input type="text" name="adsoyad" class="form-control name" placeholder="İsminiz*" required>
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">E-Posta Adresi: </p>
                                <span>Doğruluk için lütfen e-posta adresinizi dikkatlice kontrol edin</span>
                                <input type="email" name="email" class="form-control email"
                                       placeholder="E-Posta Adresiniz*">
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">Telefon Numarası: </p>
                                <input type="tel" name="telno" class="form-control" placeholder="(555) 555 55 55" required>
                            </div>


                            <div class="col-md-6">
                                <p class="p-lg">İl: </p>
                                <select class="form-select subject" name="il" id="Iller"
                                        aria-label="Default select example">
                                    <option value="0">Lütfen Bir İl Seçiniz</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <p class="p-lg">İlçe: </p>
                                <select class="form-select subject" name="ilce" id="Ilceler"
                                        aria-label="Default select example">
                                    <option value="0">Lütfen Önce bir İl seçiniz</option>
                                </select>
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">Adres: </p>
                                <input type="text" name="acikadres" class="form-control" placeholder="Adres*">
                            </div>


                            <div class="col-md-6">
                                <p class="p-lg">Doğum Tariniz: </p>
                                <input type="date" name="dogumtarihi" class="form-control name" placeholder="İsminiz*" required>
                            </div>

                            <div class="col-md-6">
                                <p class="p-lg">Doğum Yeriniz: </p>
                                <input type="text" name="dogumyeri" class="form-control name" placeholder="Doğum Yeri*">
                            </div>

                            <div class="col-md-12 input-subject">
                                <p class="p-lg">Cinsiyetiniz: </p>
                                <select class="form-select subject" name="cinsiyet" aria-label="Default select example" required>
                                    <option selected>Seçiniz</option>
                                    <option>Bay</option>
                                    <option>Bayan</option>
                                </select>
                            </div>

                            <div class="col-md-6 input-subject">
                                <p class="p-lg">Medeniyet Haliniz: </p>
                                <select class="form-select subject" name="medeniyethali"
                                        aria-label="Default select example">
                                    <option selected>Seçiniz</option>
                                    <option>Evli</option>
                                    <option>Bekar</option>
                                </select>
                            </div>


                            <div class="col-md-6 input-subject">
                                <p class="p-lg">Ehliyet Durumu: </p>
                                <select class="form-select subject" name="ehliyetdurumu"
                                        aria-label="Default select example">
                                    <option selected>Seçiniz</option>
                                    <option>Var</option>
                                    <option>Yok</option>
                                </select>
                            </div>

                            <div class="col-md-6 input-subject">
                                <p class="p-lg">Askerlik Durumu: </p>
                                <select class="form-select subject" name="askerlikdurumu"
                                        aria-label="Default select example">
                                    <option selected>Seçiniz</option>
                                    <option>Muaf</option>
                                    <option>Yaptım</option>
                                    <option>Yapmadım</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <p class="p-lg">Askerlik Tecil Tarihi: </p>
                                <input type="date" name="teciltarihi" class="form-control" placeholder="Tecil Tarihi*">
                            </div>

                            <div class="col-md-6 input-subject">
                                <p class="p-lg">İngilizce Bilginiz: </p>
                                <select class="form-select subject" name="ingilizcebilgisi"
                                        aria-label="Default select example">
                                    <option selected>Seçiniz</option>
                                    <option>Bilmiyorum</option>
                                    <option>A1 (Başlangıç)</option>
                                    <option>A2 (Elementary İngilizce)</option>
                                    <option>B1 (Orta Seviye İngilizce)</option>
                                    <option>B2 (Orta-Üstü İngilizce)</option>
                                    <option>C1 (İleri İngilizce)</option>
                                    <option>C2 (İngilizce Yeterliliği)</option>
                                </select>
                            </div>

                            <div class="col-md-6 input-subject">
                                <p class="p-lg">Eğitim Seviyeniz: </p>
                                <select class="form-select subject" name="egitimseviyesi"
                                        aria-label="Default select example">
                                    <option selected>Seçiniz</option>
                                    <option>İlkokul eğitimi</option>
                                    <option>Ortaokul eğitimi</option>
                                    <option>Ortaöğretim Eğitimi</option>
                                    <option>Önlisans Eğitimi</option>
                                    <option>Lisans Eğitimi</option>
                                    <option>Yüksek Lisans Eğitimi</option>
                                </select>
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">İş Tecrübeleri: </p>
                                <input type="text" name="istecrubeleri" class="form-control" placeholder="*" required>
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">Bilgisayar Bilgileriniz: </p>
                                <input type="text" name="bilgisayarbilgisi" class="form-control" placeholder="*">
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">Referanslarınız: </p>
                                <input type="text" name="referanslar" class="form-control" placeholder="*">
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">Başvurduğunuz Pozisyon: </p>
                                <input type="text" name="istenilenpozisyon" class="form-control" placeholder="*">
                            </div>

                            <div class="col-md-12">
                                <p class="p-lg">Ücret Beklentiniz: </p>
                                <input type="number" name="ucretbeklentisi" class="form-control" placeholder="*">
                            </div>

                            <div class="col-md-12">
                                <p class="p-">CV: </p>
                                <input type="file" name="cv" id="cv" class="form-control-file" placeholder="*">
                            </div>
                            <div><br></div>
                            <div class="col-md-12">
                                <p class="p-lg">Eklemek istediğiniz bilgiler: </p>
                                <textarea class="form-control message" name="mesaj" rows="6"
                                          placeholder="..."></textarea>
                            </div>

                            <!-- Contact Form Button -->
                            <div class="col-md-12 mt-15 form-btn text-right">
                                <button type="submit" class="btn btn-skyblue tra-grey-hover submit">Cevapları Gönder
                                </button>
                            </div>

                            <!-- Contact Form Message -->
                            <div class="col-lg-12 contact-form-msg">
                                <span class="loading"></span>
                            </div>

                        </form>
                    </div>
                </div>
            </div>       <!-- END CONTACT FORM -->


        </div>       <!-- End container -->
    </section>    <!-- END CONTACTS-2 -->




    <!-- DIVIDER LINE -->
    <hr class="divider">



    <!--  ABONE OL -->
    <section id="newsletter-1" class="newsletter-section division">
        <div class="container">
            <div class="newsletter-wrapper bg-white">
                <div class="row d-flex align-items-center row-cols-1 row-cols-lg-2">


                    <!-- NEWSLETTER TEXT -->
                    <div class="col">
                        <div class="newsletter-txt pr-20">
                            <p class="p">Sizde Quark Ticari'yi denemek için ve diğer tüm sorular için bize
                                bilgi@qryazilim.com mail üzerinden ya da +90(551) 047 57 86 numarasından
                                ulaşabilirsiniz.</p>
                        </div>
                    </div>


                    <!-- NEWSLETTER FORM -->
                    <div class="col">

                        @include('front.tekparca.aboneolparca')

                    </div>      <!-- END NEWSLETTER FORM -->


                </div>      <!-- End row -->
            </div>    <!-- End newsletter-wrapper -->
        </div>       <!-- End container -->
    </section>    <!-- END NEWSLETTER-1 -->





@endsection
@section('js')
<script src="{{asset('js/wow.js')}}"></script>
<script src="{{asset('js/iller.js')}}"></script>
@endsection
