<!DOCTYPE html>
<html lang="tr">
<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="author" content="QR Yazılım "/>
    <meta name="description" content="QR Yazılım - @yield('description')"/>
    <meta name="keywords" content="QR Yazılım, Yazılım, Ticaret, Ticari, Muhasebe, Muhasebe Yazılımı, İnternet Sitesi, HTML5, Software, Mobil, Startup, Creative, Freelancers, Digital Product, @yield('keywords')">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

    <!-- SITE TITLE -->
    <title>@yield('title')</title>

    <!-- FAVICON AND TOUCH ICONS -->
    <link rel="shortcut icon" href="{{asset('images/favicon16x16.png')}}" type="image/x-icon">
    <link rel="icon" href="{{asset('images/favicon.ico')}}" type="image/x-icon">
    <link rel="apple-touch-icon" sizes="152x152" href="{{asset('images/apple-touch-icon-152x152.png')}}">
    <link rel="apple-touch-icon" sizes="120x120" href="{{asset('images/apple-touch-icon-120x120.png')}}">
    <link rel="apple-touch-icon" sizes="76x76" href="{{asset('images/apple-touch-icon-76x76.png')}}">
    <link rel="apple-touch-icon" href="{{asset('images/apple-touch-icon.png')}}">
    <link rel="icon" href="{{asset('images/apple-touch-icon.png')}}" type="image/x-icon">

    <!-- GOOGLE FONTS -->
    <link href="https://fonts.googleapis.com/css2?family=Rubik:wght@300;400;500;700&display=swap" rel="stylesheet">

    <!-- BOOTSTRAP CSS -->
    <link href="{{ asset('css/bootstrap.min.css')}}" rel="stylesheet">

    <!-- FONT ICONS -->
    <link href="{{asset('css/flaticon.css')}}" rel="stylesheet">

    <!-- PLUGINS STYLESHEET -->
    <link href="{{asset('css/menu.css')}}" rel="stylesheet">
    <link id="effect" href="{{asset('css/dropdown-effects/fade-down.css')}}" media="all" rel="stylesheet">
    <link href="{{asset('css/magnific-popup.css')}}" rel="stylesheet">
    <link href="{{asset('css/owl.carousel.min.css')}}" rel="stylesheet">
    <link href="{{asset('css/owl.theme.default.min.css')}}" rel="stylesheet">

    <!-- ON SCROLL ANIMATION -->
    <link href="{{asset('css/animate.css')}}" rel="stylesheet">

    <!-- TEMPLATE CSS -->
    <link href="{{asset('css/style.css')}}" rel="stylesheet">

    <!-- RESPONSIVE CSS -->
    <link href="{{asset('css/responsive.css')}}" rel="stylesheet">
    @yield('css')
</head>



<body>




<!-- PRELOADER SPINNER
============================================= -->
<div id="loading">
    <div id="loading-center">
        <div id="loading-center-absolute">
            <div class="object" id="object_one"></div>
            <div class="object" id="object_two"></div>
            <div class="object" id="object_three"></div>
            <div class="object" id="object_four"></div>
        </div>
    </div>
</div>




<!-- PAGE CONTENT
============================================= -->
<div id="page" class="page">




    <!-- HEADER
    ============================================= -->
    <header id="header" class="header tra-menu navbar-@yield('menustyle')">
        <div class="header-wrapper">


            <!-- MOBILE HEADER -->
            <div class="wsmobileheader clearfix">
                <span class="smllogo"><img src="/images/logo-01.png" alt="mobile-logo"/></span>
                <a id="wsnavtoggle" class="wsanimated-arrow"><span></span></a>
            </div>


            <!-- NAVIGATION MENU -->
            <div class="wsmainfull menu clearfix">
                <div class="wsmainwp clearfix">


                    <!-- HEADER LOGO -->
                    <div class="desktoplogo"><a href="/" class="logo-black"><img src="/images/logo-01.png" alt="header-logo"></a></div>
                    <div class="desktoplogo"><a href="/" class="logo-white"><img src="/images/logo-white.png" alt="header-logo"></a></div>


                    <!-- MAIN MENU -->
                    <nav class="wsmenu clearfix">
                        <ul class="wsmenu-list nav-red-hover">


                            <!-- MEGAMENU -->
                            <li aria-haspopup="false"><a href="/">Anasayfa </a>

                            </li>	<!-- END MEGAMENU -->

                            <!-- MEGAMENU -->
                            <li aria-haspopup="true" class="mg_link"><a href="#">Kurumsal <span class="wsarrow"></span></a>
                                <div class="wsmegamenu clearfix halfmenu">
                                    <div class="container-fluid">
                                        <div class="row">

                                            <ul class="col-lg-6 link-list">
                                                <li aria-haspopup="true"><a href="{{route("hakkimizda")}}">Hakkımızda</a></li>
                                                <li aria-haspopup="true"><a href="{{route("misyon")}}">Neden Biz / Misyon & Vizyon</a></li>
                                                <li aria-haspopup="true"><a href="{{route("referanslar")}}">Referanslarımız</a></li>
                                            </ul>

                                            <ul class="col-lg-6 link-list">
                                                <li aria-haspopup="true"><a href="{{route("createisbasvurusu")}}">İş Başvurusu</a></li>
                                                <li aria-haspopup="true"><a href="{{route("createstaj")}}">Staj Başvurusu</a></li>
                                            </ul>

                                        </div>  <!-- End row -->
                                    </div>  <!-- End container -->
                                </div>  <!-- End wsmegamenu -->
                            </li>	<!-- END MEGAMENU -->

{{--                            <!-- DROPDOWN MENU -->--}}
{{--                            <li aria-haspopup="true"><a href="#">Kurumsal <span class="wsarrow"></span></a>--}}
{{--                                <ul class="sub-menu">--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("hakkimizda")}}">Hakkımızda</a></li>--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("misyon")}}">Neden Biz / Misyon & Vizyon</a></li>--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("referanslar")}}">Referanslarımız</a></li>--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("createisbasvurusu")}}">İş Başvurusu</a></li>--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("createstaj")}}">Staj Başvurusu</a></li>--}}
{{--                                </ul>--}}
{{--                            </li>--}}

                            <!-- DROPDOWN MENU -->
                            <li aria-haspopup="true"><a href="{{route("urunler")}}">Ürünlerimiz <span class="wsarrow"></span></a>
                                <ul class="sub-menu">
                                    @if(!(empty($urunler)))
                                    @foreach($urunler as $urun)
                                    <li aria-haspopup="true"><a href="{{route("urungetir",["id"=>$urun->id])}}">{{  $urun->program_kisa_adi }}</a></li>
                                    @endforeach
                                    @endif
                                        <li aria-haspopup="true"><a href="{{route("blog",["id"=>3])}}">E-Dönüşüm</a></li>
                                        <li aria-haspopup="true"><a href="{{route("blog",["id"=>5])}}">QR Mobil Sulama</a></li>
                                </ul>
                            </li>


{{--                            <li aria-haspopup="true" class="mg_link"><a href="{{route("urunlerimiz")}}">Ürünlerimiz <span class="wsarrow"></span></a>--}}
{{--                                <div class="wsmegamenu w-75 clearfix">--}}
{{--                                    <div class="container">--}}
{{--                                        <div class="row">--}}

{{--                                            <!-- MEGAMENU LINKS -->--}}
{{--                                            <ul class="col-md-6 col-lg-4 link-list">--}}
{{--                                                <li class="fst-li"><a href="{{route("quarkticari")}}">Quark Ticari</a></li>--}}
{{--                                                <li><a href="{{route("edonusum")}}">E-Dönüşüm</a></li>--}}
{{--                                                <li><a href="{{route("quarkticari")}}">Cari İşlemleri</a></li>--}}
{{--                                                <li><a href="{{route("quarkticari")}}">Stok İşlemleri</a></li>--}}
{{--                                                <li><a href="{{route("quarkticari")}}">Fatura İşlemleri</a></li>--}}
{{--                                            </ul>--}}

{{--                                            <!-- MEGAMENU LINKS -->--}}
{{--                                            <ul class="col-md-6 col-lg-4 link-list">--}}
{{--                                                <li class="fst-li"><a href="{{route("quarkpos")}}">Quark Hızlı (Pos) Satış</a></li>--}}
{{--                                                <li class="fst-li"><a href="{{route("quarkmobil")}}">Quark Mobil</a></li>--}}
{{--                                                <li><a href="{{route('yapimasamasi')}}">QR Pos Lite</a></li>--}}
{{--                                                <li><a href="{{route('yapimasamasi')}}">Stok Takip</a></li>--}}
{{--                                                <li><a href="{{route('yapimasamasi')}}">Alım Satış Fiş - Fatura</a></li>--}}
{{--                                            </ul>--}}


{{--                                            <!-- MEGAMENU LINKS -->--}}
{{--                                            <ul class="col-md-6 col-lg-4 link-list">--}}
{{--                                                <li class="fst-li"><a href="{{route("quarkres")}}">Quark Restorant</a></li>--}}
{{--                                                <li><a href="{{route("quarksulama")}}">Sulama Otomasyonu</a></li>--}}
{{--                                                <li><a href="{{route("quarkdtemin")}}">Doğrudan Temin</a></li>--}}
{{--                                                <li><a href="{{route("quarkanalitik")}}">Analitik Bütçe</a></li>--}}
{{--                                                <li><a href="{{route("quarksafe")}}">Safe(Veresiye)</a></li>--}}
{{--                                            </ul>--}}

{{--                                        </div>  <!-- End row -->--}}
{{--                                    </div>  <!-- End container -->--}}
{{--                                </div>  <!-- End wsmegamenu -->--}}
{{--                            </li>	<!-- END MEGAMENU -->--}}


                            <!-- DROPDOWN MENU -->
{{--                            --}}
{{--                            <li aria-haspopup="true"><a href="#">İletişim<span class="wsarrow"></span></a>--}}
{{--                                <ul class="sub-menu">--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("iletisim")}}">İletişim Formu</a></li>--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("createisbasvurusu")}}">İş Başvurusu</a></li>--}}
{{--                                    <li aria-haspopup="true"><a href="{{route("createstaj")}}">Staj Başvurusu</a></li>--}}
{{--                                </ul>--}}
{{--                            </li>--}}
{{--                            --}}
                            <!-- DROPDOWN MENU -->
                            <li aria-haspopup="true"><a href="#">İndirmeler<span class="wsarrow"></span></a>
                                <ul class="sub-menu">
                                    <li aria-haspopup="true"><a href="{{route("demoindir")}}">Demo İndir</a></li>
                                    <li aria-haspopup="true"><a href="{{route('premiumindir')}}">Premium İndir</a></li>
                                    @if(\Illuminate\Support\Facades\Auth::user())
                                        <div>
                                        <li aria-haspopup="true"><a href="#">Yetkili<span class="wsarrow"></span></a>
                                            <ul class="sub-menu">
                                                <li aria-haspopup="true"><a href="{{route('premiumindir')}}">Premium İndir</a></li>
                                                <li aria-haspopup="true"><a href="{{route('logout')}}">Çıkış Yap</a></li>
                                            </ul>
                                        </li>
                                    @endif
                                </ul>
                            </li>




                            <!-- HEADER BUTTON -->
                            <li class="nl-simple" aria-haspopup="true">
                                <a href="{{route("iletisim")}}" class="btn btn-red last-link">İletişim</a>
                            </li>



                        </ul>
                    </nav>	<!-- END MAIN MENU -->


                </div>
            </div>	<!-- END NAVIGATION MENU -->


        </div>     <!-- End header-wrapper -->
    </header>
</div>
<body>


