@extends('front.layouts.master')
@section('title','QR Yazılım - İleri Teknoloji')
@section('menustyle','dark')
@section('content')

    <!-- PAGE CONTENT
		============================================= -->
    <div id="page" class="page">


        <!-- SINGLE POST
        @user::
                ============================================= -->
        <section id="single-post" class="wide-100 inner-page-hero single-post-section division">
            <div class="container">
                @if (session('updateStatus'))
                    <button><a href="" class="btn btn-tra-indigo">Düzenle</a></button>
                    <h6 class="alert alert-success">{{ session('updateStatus') }}</h6>
                @endif

                <div class="card">
                    <h4 class="text-color-danger mt-20 mb-20 align-self-center"> Düzenleme Formu  <a href="{{'/premiumindirmeyfasi'}}" ><button class="btn-danger align-content-end">Geri Dön</button></a></h4>

                    <div class="card-header">
                        @if(\Illuminate\Support\Facades\Auth::user()->yetki ==1)<div>
                            <div class="row justify-content-center">
                                <div class="col-lg-10 col-xl-8">
                                    <div class="form-holder">


                                        <form method="post" id="form_validation" class="row contact-form" type="submit"  enctype="multipart/form-data"
                                              action="{{ url('update-premiumindirmesayfasi/'.$programv->id) }}">
                                            @csrf

                                            <div class="col-md-6">
                                                <p class="p-lg">Program Versiyon: </p>
                                                <input type="text" name="programversion" class="form-control"
                                                       placeholder="Yüklemiş Olduğunuz Versiyon*" required value="{{$programv->program_id}}" disabled>
                                            </div>

                                            <div class="col-md-6">
                                                <p class="p-lg">Program Versiyon: </p>
                                                <input type="text" name="programversion" class="form-control"
                                                       placeholder="Yüklemiş Olduğunuz Versiyon*" required value="{{$programv->program_versiyon}}">
                                            </div>
                                            <div class="col-md-12">
                                                <p class="p-lg">Program Açıklama: </p>
                                                <textarea class="form-control" id="task-textaera" name="programaciklama" rows="6">{{$programv->program_aciklama}}</textarea>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="p-lg">İndirme linki: </p>
                                                <input type="text" name="indirmelink" value="{{$programv->program_versiyon_link}}" class="form-control" required>
                                            </div>
                                            <div class="col-md-2">
                                                <p class="p-lg">Sıra No: </p>
                                                <input type="number" name="sirano" value="{{$programv->sira_no}}" class="form-control"
                                                       placeholder="Sıra Numarası" required>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="p-lg">Program Modal Name: </p>
                                                <select class="form-select subject" value="{{$programv->program_modal_name}}" name="modalname"
                                                        aria-label="Default select example">
                                                    <option selected>Seçiniz</option>
                                                    <option selected>{{$programv->program_modal_name}}</option>
{{--                                                    @foreach($programv as $urun)--}}
{{--                                                    <option>{{ $programv->program_modal_name    }}</option>--}}
{{--                                                    @endforeach--}}
                                                </select>
                                            </div>
                                            <div class="col-md-12">
                                                <p class="p-">Programın Dosyasını Yükleyiniz: </p>
{{--                                                {!! Form::file('programdosyayukle', array('class' => 'form-control','id'=>'programdosyayukle')) !!}--}}
                                                <input type="file" id="programdosyayukle" name="programdosyayukle" class="form-control" placeholder="*">
                                            </div>

                                            <!-- Contact Form Button -->
                                            <div class="col-md-12 mt-15 form-btn text-right">
                                                <button type="submit" class="btn btn-skyblue tra-grey-hover submit">Programı Ekle
                                                </button>
                                            </div>
                                            <!-- Contact Form Message -->
                                            <div class="col-lg-12 contact-form-msg">
                                                <span class="loading"></span>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>       <!-- END CONTACT FORM -->
                        </div>
                        @endif
            </div>
                </div>
            </div>

        </section>    <!-- END SINGLE POST -->

    </div>
@endsection
@section('js')

    <script src="https://cdn.ckeditor.com/ckeditor5/35.4.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create( document.querySelector( '#task-textaera' ) )
            .catch( error => {
                console.error( error );
            } );
    </script>

@endsection
@section('css')
    <link rel="stylesheet" href="{{asset('assest/css/theme-elements.css')}}">


@endsection

