@extends('front.layouts.master')
@section('title','QR Yazılım - İleri Teknoloji')
@section('menustyle','dark')
@section('content')

    <!-- PAGE CONTENT
		============================================= -->
    <div id="page" class="page">
        @if(session('toast_success'))
            <div>
                {{session('toast_success')}}
            </div>
        @endif
        @include('sweetalert::alert')

        <!-- SINGLE POST
        @user::
                ============================================= -->
        <section id="single-post" class="wide-100 inner-page-hero single-post-section division">
            <div class="container">


                <ul class="nav nav-pills mb-3 justify-content-center" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">Programlar</button>
                    </li>
                    @if(\Illuminate\Support\Facades\Auth::user()->yetki ==1)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab-1" data-bs-toggle="pill" data-bs-target="#pills-profile-1" type="button" role="tab" aria-controls="#pills-profile-1" aria-selected="false">Program Ekle</button>
                    </li>
{{--                        <li class="nav-item" role="presentation">--}}
{{--                        <button class="nav-link" id="pills-profile-tab-2" data-bs-toggle="pill" data-bs-target="#pills-profile-2" type="button" role="tab" aria-controls="#pills-profile-2" aria-selected="false">Program Düzenle</button>--}}
{{--                    </li>--}}
                     @endif
                </ul>
                <hr>


                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">



                        <div class="row justify-content-evenly">

                            @foreach($urunler as $urun)

                            <div class="card text-center" style="width: 20rem;">
                                <img src="{{$urun->program_icon}}" class="card-img-top" alt="Quark Ticari">
                                <div class="card-body">
                                    <h5 class="card-title">{{$urun->program_adi}}</h5>
                                    <p class="card-text"></p>
                                    <a href="/programindir/{{$urun->lastversiyon['id']}}" class="btn btn-red tra-black-hover" style="width: auto; align-content: center;" download>Son Versiyonu İNDİR  </a>
                                    <table class="table table-striped">
                                        <tr class="table-primary">
                                            <p><a href="#" class="card-link blue-color" ></a></p>
                                        </tr>
                                        <hr>

                                        @foreach($urun->versiyon as $versiyon)
                                            @if($urun->lastversiyon->program_id = 1)
                                        <tr class="table-primary">
                                            <p>{{str_replace(" ", ".",$versiyon->program_versiyon) }} <a href="/programindir/{{$versiyon->program_id}}" class="card-link red-color" >İndir</a>

                                                @if(\Illuminate\Support\Facades\Auth::user()->yetki ==1)
                                                    <a href="/premiumindiredit/{{$versiyon->id}}" class="card-link indigo-color" >Düzenle</a>
                                                @endif
                                            </p>
                                            <hr>
                                        </tr>
                                            @endif
                                        @endforeach
                                    </table>
                                </div>
                            </div>

                            @endforeach

{{--                            <div class="card text-center" style="width: 20rem;">--}}
{{--                                <img src="images/iconlar/QRK-POS.png" class="card-img-top" alt="Quark Hızlı Satış">--}}
{{--                                <div class="card-body">--}}
{{--                                    <h5 class="card-title">Quark (Pos) Hızlı Satış</h5>--}}
{{--                                    <p class="card-text"></p>--}}
{{--                                    <a href="/download/quarkpos.zip" class="btn btn-red tra-black-hover" style="width: auto; align-content: center;" download>Son Versiyonu İNDİR</a>--}}
{{--                                </div>--}}
{{--                            </div>--}}

{{--                            <div class="card text-center" style="width: 20rem;">--}}
{{--                                <img src="images/iconlar/QRK-MOBIL.png" class="card-img-top" alt="Quark Mobil">--}}
{{--                                <div class="card-body">--}}
{{--                                    <h5 class="card-title">Quark Mobil</h5>--}}
{{--                                    <p class="card-text"></p>--}}
{{--                                    <a href="/programindir/1" class="btn btn-red tra-black-hover" style="width: auto; align-content: center;" download>Son Versiyonu İNDİR</a>--}}
{{--                                </div>--}}
{{--                            </div>--}}


                        </div>



                    </div>
                    <div class="tab-pane fade" id="pills-profile-1" role="tabpanel" aria-labelledby="pills-profile-tab-1">


                        @if(\Illuminate\Support\Facades\Auth::user()->yetki ==1)<div>
                            <!-- CONTACT FORM -->
                            <div class="row justify-content-center">
                                <div class="col-lg-10 col-xl-8">
                                    <div class="form-holder">

                                        <form method="post" id="form_validation"  class="row contact-form" type="submit"
                                              action="{{route('createversiyon')}}" enctype="multipart/form-data">
                                            @csrf
                                            <!-- Contact Form Input -->
                                            <div class="col-md-6">
                                                <p class="p-lg">Program Adı: </p>
                                                <select class="form-select subject" name="program_adi"
                                                        aria-label="Default select example">
                                                    <option selected>Seçiniz</option>
                                                    @foreach($urunler as $urun)
                                                        <option value='{{$urun->id}}'>{{$urun->program_adi}}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="col-md-6">
                                                <p class="p-lg">Program Versiyon: </p>
                                                <input type="text" name="program_versiyon" class="form-control"
                                                       placeholder="Yüklemiş Olduğunuz Versiyon*" required>
                                            </div>
                                            <div class="col-md-12">
                                                <p class="p-lg">Program Açıklama: </p>
                                                <textarea class="form-control" name="program_aciklama" rows="6"
                                                          placeholder=""></textarea>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="p-lg">Sıra Numarası: </p>
                                                <input type="number" name="sira_no" class="form-control"
                                                       placeholder="Sıra Numarası" required>
                                            </div>
                                            <div class="col-md-6">
                                                <p class="p-lg">Program Modal Name: </p>
                                                <input type="text" name="program_modal_name" class="form-control"
                                                       placeholder="#modalticari & #modalpos" required>
                                            </div>
                                            <div class="col-md-12">
                                                <p class="p-">Programın Dosyasını Yükleyiniz: </p>
                                                <input type="file" name="programdosyayukle" id="programdosyayukle" class="form-control-file" placeholder="*">
                                            </div>

                                            <!-- Contact Form Button -->
                                            <div class="col-md-12 mt-15 form-btn text-right">
                                                <button type="submit" class="btn btn-skyblue tra-grey-hover submit">Programı Ekle
                                                </button>
                                            </div>
                                            <!-- Contact Form Message -->
                                            <div class="col-lg-12 contact-form-msg">
                                                <span class="loading"></span>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>       <!-- END CONTACT FORM -->
                        </div>
                        @endif
{{--                    </div>--}}
{{--                    <div class="tab-pane fade" id="pills-profile-2" role="tabpanel" aria-labelledby="pills-profile-tab-2">--}}


{{--                        @if(\Illuminate\Support\Facades\Auth::user()->yetki ==1)<div>--}}
{{--                            <!-- CONTACT FORM -->--}}
{{--                            <table class="table">--}}
{{--                                <thead class="thead-dark">--}}
{{--                                <tr>--}}
{{--                                    <th scope="col">#ID</th>--}}
{{--                                    <th scope="col">Program ID</th>--}}
{{--                                    <th scope="col">Program Versiyon</th>--}}
{{--                                    <th scope="col">Program Açıklaması</th>--}}
{{--                                    <th scope="col">Program Versiyon Linki(İndirme)</th>--}}
{{--                                    <th scope="col">Sıra No</th>--}}
{{--                                    <th scope="col">Program Modal'ı</th>--}}
{{--                                    <th></th>--}}
{{--                                </tr>--}}
{{--                                </thead>--}}
{{--                                <tbody>--}}
{{--                                @foreach($urunler as $urun)--}}
{{--                                <tr>--}}
{{--                                    <th scope="row">{{$urun->lastversiyon->id}}</th>--}}
{{--                                    <td>{{$urun->lastversiyon->program_id}}</td>--}}
{{--                                    <td>{{$urun->lastversiyon->program_versiyon}}</td>--}}
{{--                                    <td>{!! str_limit($urun->lastversiyon->program_aciklama,50)  !!}</td>--}}
{{--                                    <td>{{$urun->lastversiyon->program_versiyon_link}}</td>--}}
{{--                                    <td>{{$urun->lastversiyon->sira_no}}</td>--}}
{{--                                    <td>{{$urun->lastversiyon->program_modal_name}}</td>--}}
{{--                                    <td><a href="{{ url('premiumindiredit/'.$urun->lastversiyon->id) }}" class="btn btn-tra-indigo">Düzenle</a></td>--}}
{{--                                </tr>--}}
{{--                                @endforeach--}}
{{--                                </tbody>--}}
{{--                            </table>--}}
{{--                        </div>--}}
{{--                        @endif--}}
{{--                    </div>--}}
                </div>









            </div>

        </section>    <!-- END SINGLE POST -->

    </div>
@endsection
@section('js')

    <script src="https://cdn.ckeditor.com/ckeditor5/35.4.0/classic/ckeditor.js"></script>
    <script>
        ClassicEditor
            .create( document.querySelector( '#task-textaera' ) )
            .catch( error => {
                console.error( error );
            } );
    </script>
    <script src="https://kit.fontawesome.com/yourcode.js" crossorigin="anonymous"></script>


@endsection
@section('css')
    <link rel="stylesheet" href="{{asset('assest/css/theme-elements.css')}}">


@endsection

