@extends('front.layouts.master')
@section('title',$urun->program_adi .  ' - QR Yazılım')
@section('description', $urun->program_adi . ' hem kullanıcı dostu hem de kolay arayüzüyle bütün işlerinizi kolaylaştırıp hızlandırmak için yazıldı.')
@section('menustyle','dark')
@section('content')

    <!-- PAGE CONTENT
		============================================= -->
    <div id="page" class="page">


        <!-- SINGLE POST
                ============================================= -->
        <section id="single-post" class="wide-100 inner-page-hero single-post-section division">
            <div class="container">


                <!-- SINGLE POST CONTENT -->
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <div class="single-post-wrapper">


                            <!-- SINGLE POST TITLE -->
                            <div class="single-post-title">

                                <!-- CATEGORY -->
                                <div class="row">
                                    <div class="col">
                                        <ul class="breadcrumb breadcrumb-style-2 d-block text-4 mb-4">
                                            <li><a href=""
                                                   class="text-color-default text-color-hover-primary text-decoration-none">Anasayfa</a>
                                            </li>
                                            <li><a href="{{route("urunler")}}"
                                                   class="text-color-default text-color-hover-primary text-decoration-none">Ürünlerimiz</a>
                                            </li>

                                            <li>{{$urun->program_adi}}</li>
                                        </ul>
                                    </div>
                                </div>

                                <!-- TITLE -->
                                <div class="position-relative">
                                <h2 class="h2-md">{{$urun->program_adi}}</h2>
                                    <div class="position-absolute top-0 end-0"> <a href="{{route("demoindir")}}" ><button style="background-color: {{$urun->program_ucretsiz_deneme_renk}}" class="btn"> Ücretsiz Deneme</button> </a></div>
                                <p>{{$urun->program_kisa_aciklama}} </p>
                                </div>
                                <section>
                                    <!-- Carousel -->
                                    <div id="demo" class="carousel slide" data-bs-ride="carousel">
                                        <!-- Indicators/dots -->
                                        <div class="carousel-indicators">
                                            <button type="button" data-bs-target="#demo" data-bs-slide-to="0"
                                                    class="active"
                                                    style="color: #0a1339"></button>
                                            <button type="button" data-bs-target="#demo" data-bs-slide-to="1"
                                                    style="color: #0a1339"></button>
                                            <button type="button" data-bs-target="#demo" data-bs-slide-to="2"
                                                    style="color: #0a1339"></button>
                                        </div>

                                        <!-- The slideshow/carousel -->
                                        <div id="carouselExampleFade" class="carousel slide carousel-fade" data-bs-ride="carousel">
                                        <div class="carousel-inner">
                                            <?php
                                            $i=0;
                                            ?>
                                            @foreach($urun->resimler as $resim)
                                            <div class="carousel-item @if($i == 0) {{"active"}} @endif">
                                                <img
                                                    src="{{$resim->resim_dosya_ismi}}" alt="{{$resim->resim_aciklama}}"
                                                    class="mx-auto d-block mt-3 img-fluid">
                                                <div class="carousel-caption d-none d-md-block">
                                                </div>
                                            </div>
                                              <?php
                                                $i++;
                                                ?>
                                            @endforeach
                                        </div>
                                        </div>

                                        <!-- Left and right controls/icons -->
                                        <button class="carousel-control-prev indigo-color" type="button" data-bs-target="#demo"
                                                data-bs-slide="prev"
                                                style="color: #0a1339">
                                            <span class="carousel-control-prev-icon" style="color: #0a1339"></span>
                                        </button>
                                        <button class="carousel-control-next" type="button" data-bs-target="#demo"
                                                data-bs-slide="next"
                                                style="color: #0a1339">
                                            <span class="carousel-control-next-icon" style="color: #0a1339"></span>
                                        </button>
                                    </div>
                                </section>

                                <!-- POST DATA -->
                                <div class="post-data clearfix">

                                </div>    <!-- END SINGLE POST TITLE -->


                                <!-- BLOG POST TEXT -->
                                <div class="single-post-txt">

                                    {!! $urun->program_aciklama !!}

                                </div>    <!-- END BLOG POST TEXT -->

                                <!-- BLOG POST TEXT -->
                                <div class="single-post-txt">

                                     <div class="accordion accordion-flush" id="accordionPanelsStayOpenExample">

                                    @foreach($urun->ozellikler as $ozellik)



                                        <div class="accordion-item">
                                            <h2 class="accordion-header" style="margin-bottom: 10px"  id="panelsStayOpen-heading{{$ozellik->id}}">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapse{{$ozellik->id}}" aria-expanded="false" aria-controls="panelsStayOpen-collapse{{$ozellik->id}}">
                                                   <P>{{$ozellik->program_baslik}} </P>
                                                </button>
                                            </h2>
                                            <div id="panelsStayOpen-collapse{{$ozellik->id}}" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-heading{{$ozellik->id}}">
                                                <div class="accordion-body">
                                                 {!! $ozellik->program_ozellik  !!}

                                                    <a><img src="{{$ozellik->program_resim}}"></a>

                                                </div>
                                            </div>
                                        </div>



                                    @endforeach

                                    </div>

                                    <!-- SINGLE POST SHARE LINKS -->
                                    <div class="row post-share-links d-flex align-items-center">

                                        <div class="col-md-9 col-xl-8 post-tags-list">
                                            @if(!(empty($urunler)))
                                                @foreach($urunler as $urun)
                                                    <span><a href="{{route("urungetir",["id"=>$urun->id])}}">{{  $urun->program_kisa_adi }}</a></span>
                                                @endforeach
                                            @endif
                                        </div>

                                        <!-- POST SHARE ICONS -->
                                        <div class="col-md-3 col-xl-4 post-share-list text-end">
                                            <ul class="share-social-icons ico-25 text-center clearfix">
                                                <li><a href="https://www.twitter.com/qryazilim" class="share-ico"><span
                                                            class="flaticon-twitter"></span></a>
                                                </li>
                                                <li><a href="https://www.facebook.com/qryazilim" class="share-ico"><span
                                                            class="flaticon-facebook"></span></a></li>
                                                <li><a href="https://www.instagram.com/qryazilim"
                                                       class="share-ico"><span
                                                            class="flaticon-instagram"></span></a></li>
                                                <li><a href="https://www.youtube.com/channel/UCBvrsvj9-1doM-yDb1zrCtw"
                                                       class="share-ico"><span
                                                            class="flaticon-youtube"></span></a></li>
                                            </ul>
                                        </div>
                                    </div>    <!-- END SINGLE POST SHARE -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>    <!-- END SINGLE POST -->


        <!-- ABOUT POST AUTHOR
        ============================================= -->
    {{--        <div class="about-post-author bg-snow division">--}}
    {{--            <div class="container">--}}
    {{--                <div class="row">--}}
    {{--                    <div class="col-lg-10 offset-lg-1">--}}
    {{--                        <div class="author-senoff">--}}

    {{--                            <!-- Avatar -->--}}
    {{--                            <img src="images/review-author-7.jpg" alt="author-avatar">--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="author-senoff-txt">--}}

    {{--                                <!-- Title -->--}}
    {{--                                <h5 class="h5-xs">Published by</h5>--}}
    {{--                                <h5 class="h5-md">Matthew Anderson</h5>--}}
    {{--                                <p class="p-md">Lorem ipsum dolor sit amet, consectetur elit eiusmod tempor sapien dolore--}}
    {{--                                    incidide ut labore dolore incididunt ut labore turpis vitae raesent varius consectetur--}}
    {{--                                    purus efficitur ipsum primis in cubilia laoreet augue donec--}}
    {{--                                </p>--}}

    {{--                                <!-- Link -->--}}
    {{--                                <p class="author-link">All stories by <a href="#">Matthew Anderson</a></p>--}}

    {{--                                <!-- Follow Button -->--}}
    {{--                                <div class="author-follow-btn"><a href="#">Follow</a></div>--}}

    {{--                            </div>--}}

    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                </div>  <!-- End row -->--}}
    {{--            </div>  <!-- End container -->--}}
    {{--        </div>	<!-- END ABOUT POST AUTHOR -->--}}

        <!-- BLOG-1
        ============================================= -->
        <section id="blog-1" class="bg-whitesmoke-gradient wide-60 blog-section division">

            @include('front.tekparca.digerquarkurunlerimizparca')


        </section>    <!-- END BLOG-1 -->


        <!-- NEWSLETTER-1
        ============================================= -->
        <section id="newsletter-1" class="newsletter-section division">
            <div class="container">
                <div class="newsletter-wrapper bg-white">
                    <div class="row d-flex align-items-center row-cols-1 row-cols-lg-2">


                        <!-- NEWSLETTER TEXT -->
                        <div class="col">
                            <div class="newsletter-txt pr-20">
                                <p class="p">Sizde Quark Ticari'yi denemek için ve diğer tüm sorular için bize
                                    bilgi@qryazilim.com mail üzerinden ya da +90(551) 047 57 86 numarasından
                                    ulaşabilirsiniz.</p>
                            </div>
                        </div>


                        <!-- NEWSLETTER FORM -->
                        <div class="col">

                            @include('front.tekparca.aboneolparca')

                        </div>      <!-- END NEWSLETTER FORM -->


                    </div>      <!-- End row -->
                </div>    <!-- End newsletter-wrapper -->
            </div>       <!-- End container -->
        </section>    <!-- END NEWSLETTER-1 -->

    </div>
@endsection
@section('js')

@endsection
@section('css')
    <link rel="stylesheet" href="{{asset('assest/css/theme-elements.css')}}">
@endsection

