@extends('front.layouts.master')
@section('title','QR Yazılım - İleri Teknoloji')
@section('menustyle','dark')
@section('content')

    <!-- PAGE CONTENT
		============================================= -->
    <div id="page" class="page">


        <!-- SINGLE POST
                ============================================= -->
        <section id="single-post" class="wide-100 inner-page-hero single-post-section division">
            <div class="container">


                <!-- SINGLE POST CONTENT -->
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <div class="single-post-wrapper">


                            <!-- SINGLE POST TITLE -->
                            <div class="single-post-title">

                                <!-- CATEGORY -->
                                <div class="row">
                                    <div class="col">
                                        <ul class="breadcrumb breadcrumb-style-2 d-block text-4 mb-4">
                                            <li><a href=""
                                                   class="text-color-default text-color-hover-primary text-decoration-none">Anasayfa</a>
                                            </li>
                                            <li><a href="{{route("urunlerimiz")}}"
                                                   class="text-color-default text-color-hover-primary text-decoration-none">Ürünlerimiz</a>
                                            </li>
                                            <li>Quark Pos Lite</li>
                                        </ul>
                                    </div>
                                </div>

                                <!-- TITLE -->
                                <h2 class="h2-md">Quark Pos Lite</h2>
                                <p>Quark Ticari, hem kullanıcı dostu hem de kolay arayüzüyle bütün işlerinizi kolaylaştırıp hızlandırmak için yazıldı. </p>
                                <section>
                                    <!-- Carousel -->
                                    <div id="demo" class="carousel slide" data-bs-ride="carousel">
                                        <!-- Indicators/dots -->
                                        <div class="carousel-indicators">
                                            <button type="button" data-bs-target="#demo" data-bs-slide-to="0"
                                                    class="active"
                                                    style="color: #0a1339"></button>
                                            <button type="button" data-bs-target="#demo" data-bs-slide-to="1"
                                                    style="color: #0a1339"></button>
                                            <button type="button" data-bs-target="#demo" data-bs-slide-to="2"
                                                    style="color: #0a1339"></button>
                                        </div>

                                        <!-- The slideshow/carousel -->
                                        <div class="carousel-inner">
                                            <div class="carousel-item active">
                                                <img
                                                    src="images/slider/ticarislider/slider1.png" alt="Los Angeles"
                                                    class="mx-auto d-block mt-3">
                                                <div class="carousel-caption d-none d-md-block">
                                                    <h5></h5>
                                                    <p>Giriş Ekran Görüntüsü</p>
                                                </div>
                                            </div>
                                            <div class="carousel-item">
                                                <img src="images/slider/ticarislider/cari_slider.png" alt="Chicago"
                                                     class="mx-auto d-block mt-3">
                                                <div class="carousel-caption d-none d-md-block">
                                                    <h5></h5>
                                                    <p>Cari Kartı</p>
                                                </div>
                                            </div>
                                            <div class="carousel-item">
                                                <img src="images/slider/ticarislider/cari_slider2.png" alt="New York"
                                                     class="mx-auto d-block mt-3">
                                            </div>
                                        </div>

                                        <!-- Left and right controls/icons -->
                                        <button class="carousel-control-prev" type="button" data-bs-target="#demo"
                                                data-bs-slide="prev"
                                                style="color: #0a1339">
                                            <span class="carousel-control-prev-icon" style="color: #0a1339"></span>
                                        </button>
                                        <button class="carousel-control-next" type="button" data-bs-target="#demo"
                                                data-bs-slide="next"
                                                style="color: #0a1339">
                                            <span class="carousel-control-next-icon" style="color: #0a1339"></span>
                                        </button>
                                    </div>
                                </section>

                                <!-- POST DATA -->
                                <div class="post-data clearfix">

                                    {{--                                    <!-- Author Avatar -->--}}
                                    {{--                                    <div class="post-author-avatar">--}}
                                    {{--                                        <img src="images/review-author-7.jpg" alt="author-avatar">--}}
                                    {{--                                    </div>--}}

                                    {{--                                    <!-- Author Data -->--}}
                                    {{--                                    <div class="post-author">--}}
                                    {{--                                        <h6 class="h6-xl">Matthew Anderson</h6>--}}
                                    {{--                                        <p class="p-md">Posted on June 22, 2021 - 4 comments</p>--}}
                                    {{--                                    </div>--}}

                                    {{--                                </div>	<!-- END POST DATA -->--}}


                                </div>    <!-- END SINGLE POST TITLE -->


                                <!-- BLOG POST TEXT -->
                                <div class="single-post-txt">

                                    <!-- Text -->
                                    <h2>Quark Ticari Kullanışlı modülleri ile size hizmete hazır.</h2>
                                    <p class="p-lg">
                                        QR Ticari Muhasebe Programı; sağlam alt yapısı ve kullanışlı modülleri ile
                                        Elektrik-elektronik, telekomünikasyon, otomotiv, sigortacılık, marketler,
                                        tekstil ve
                                        mağazacılık, maden, inşaat, taşıma, gıda, üretim, akaryakıt vb. birçok sektöre
                                        hitap
                                        etmektedir.<br>

                                    <h3> Proje Özellikleri</h3>
                                    <!-- List -->
                                    <ul class="simple-list">

                                        <li class="list-item">
                                            <p class="p-lg">Son Teknolojilerle Yüksek Hız
                                            </p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">İleri Düzey Arayüz
                                            </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kullanıcıya Özel Modüller
                                            </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Esnek Tasarım
                                            </p>
                                        </li>
                                    </ul>

                                </div>    <!-- END BLOG POST TEXT -->


                                <!-- BLOG POST TEXT -->
                                <div class="single-post-txt">

                                    <!-- Text -->
                                    <h3>Modüller Yapı</h3>
                                    <p class="p-lg">
                                        QR Ticari yazılımı kullanışlı modülleri ile iş yükünüzü hafifletecek ve
                                        işletmenizi daha kolay yönetmenizi sağlayacaktır.
                                    </p>

                                    <h3>Çok Kullanıcılı yapısı</h3>
                                    <p class="p-lg">
                                        QR Ticari yazılımı çok kullanıcı yapısı ile personellerinizi anlık olarak
                                        kontrol edebilirsiniz
                                    </p>
                                    <h3> Sade Yapısı ile Kolay kullanım</h3>
                                    <p class="p-lg">
                                        Sade ve pratik ara yüzü ile QR Ticari yazılımı size ayak uyduracak, işletmenize
                                        en kısa zamanda adapte olacak ve işletmenizin en verimli çalışanı olacaktır.
                                    </p>
                                    <h3>Şube Sistemi</h3>
                                    <!-- List -->
                                    <ul class="simple-list">

                                        <li class="list-item">
                                            <p class="p-lg">Birden fazla şube tanımlayabilirsiniz.
                                            </p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg"> Bankalarınızı şubelerde ortak kullanabilirsiniz.
                                            </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg"> Her şubeye ayrı rapor alabilirsiniz.(Cari Bakiye, Stok
                                                Envanter, Fatura Raporu, Kasa
                                                Raporu, İrsaliye listesi vb.).

                                            </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kullanıcılarınıza şube yetkilendirmesi yapabilirsiniz. Bu
                                                sayede diğer şubenin
                                                kayıtlarına ve raporlarına ulaşımı kısıtlayabilirsiniz.
                                            </p>
                                        </li>
                                    </ul>


                                    <h3>Cari</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Cari kartlarınızı tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait iskonto tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait özel fiyat tanımları yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Cariniz süt üreticisi ise, Stopaj, Bağkur, Gelir Vergisi
                                                Borsa kesintisi ve Mera
                                                fonlarını tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait grup tanımları oluşturabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait Özel kod tanımları oluşturabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait dosya ekleyebilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Cari hareket raporu ve Cari bakiye raporlarını
                                                alabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Cari hareket ve Cari bakiye raporlarını yazdırabilir veya
                                                excele aktarabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Cari Analiz raporu alabilirsiniz. Bu sayede carilerinizin
                                                dönem bazında hangi
                                                şekilde borç/alacak işlemi yaptığını görebilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Cari Mutabakat formlarını yazdırabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Cariler arasında virman yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait borç devirlerini girebilirsiniz. </p>
                                        </li>
                                    </ul>
                                    <h3>Stok</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Cari kartlarınızı tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok Kartlarınızı tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza ait birim tanımlarını yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza ait barkod ve ek barkod tanımlarını
                                                yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınızı gruplandırabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza 3 farklı özel kod tanımı yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınızın marka ve model bilgilerini
                                                tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınızın kdv ve ötv oranlarını
                                                tanımlayabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza ait fiyat tanımlarını yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza ait iskonto tanımlarını yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınızı teraziye gönderebilmek için gerekli ayarları
                                                yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza ait özellik tanımlarını yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok resimlerini ekleyebilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok fiyat tanımları sayesinde belirli bir cariye veya
                                                belirli bir grupta bulunan
                                                carilere belirli tarihler arasında özel fiyat tanımı
                                                yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok envanter raporu alabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Hizmet tanımları yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok Kar/Zarar raporu alarak, işletmenizin hangi üründen ne
                                                kadar kar/zarar ettiğini
                                                kolay bir şekilde görebilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stoklarınıza ait analiz alabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok etiket dizaynlarını yapabilir ve
                                                yazdırabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok hareket raporu alabilir, yazdırabilir ve excele
                                                aktarabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Tek ekranda stoklarınızı listeleyerek fiyat değiştirebilir
                                                ve stok kartlarını
                                                güncelleyebilirsiniz. </p>
                                        </li>
                                    </ul>
                                    <h3>Kasa</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Kasa tanımlarını yapabilirsiniz. </p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kasalarınıza ait 3 adet özel kod girişi yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kasalarınıza gelir ve gider girişi yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kasalar arası virman yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kasa gelir ve gider girişlerinizi ayrıntılı bir şekilde
                                                görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kasa Hareket raporunu alabilir ve yazdırabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Fatura</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Alış ve Satış faturalarınızı kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Alıştan iade ve Satıştan iade faturalarınızı kayıt
                                                edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Alınan ve Verilen hizmet faturalarınızı kayıt
                                                edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura kaydına irsaliye veya teklif modülünden bilgi
                                                aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Satır bazında ve fatura bazında indirim yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Ötv ve Tevkifat oranlarını belirleyebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura kayıtlarınıza ait özel kod belirleyebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kapalı fatura özelliği ile faturaya ait ödeme veya
                                                tahsilatlarınızı fatura üzerinden
                                                girerek faturayı kapatabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Faturalarınızı kullandığınız matbuu forma göre dizayn edip
                                                yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura raporu alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura raporunu yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura raporunu excele aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura raporunu ayrıntılı yazdırabilirsiniz.(Fatura
                                                hareketleri ile birlikte).</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura BA-BS formu yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura Kdv analizi alabilir ve ödemeniz gereken kdv tutarını
                                                ay bazında
                                                görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura Kar/Zarar raporu alabilirisiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fatura - Stok raporu alabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>İrsaliye</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Gelen ve Giden İrsaliyelerinizi kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Gelen irsaliyeleri alış faturasına, giden irsaliyeleri de
                                                satış faturasına
                                                aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg"> Kayıt etmiş olduğunuz irsaliyeleri yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg"> İrsaliye kayıtlarını raporlayabilir ve bu raporu excele
                                                atabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg"> İrsaliyelerinizi kullanmış olduğunuz matbuu göre dizayn
                                                edebilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Tahakkuk</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Borç tahakkuklarınızı oluşturabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Aylık ödemelerinizi takip edebilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Son ödeme tarihlerini girerek programın sizi uyarmasını
                                                sağlayabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Tahakkuk ödemelerinizi yapabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Tahakkuk raporunu alabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Tahakkuk raporunu yazdırabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Tahakkuk raporunuzu excele aktarabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Tahakkuklarınıza ait dosyalarınızı ekleyebilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Fiş</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Alış ve Satış fişlerinizi kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok Sayım Noksanı ve Stok Sayım Fazlası fişlerini kayıt
                                                edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Stok devir fişlerinizi kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş kayıtlarını faturaya aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Satır bazında ve fiş bazında indirim yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş kayıtlarınıza ait özel kod belirleyebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fişlerinizi kullandığınız matbuu forma göre dizayn edip
                                                yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş raporu alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş raporunda aylık bazda toplamları görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş raporunu yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş raporunu ayrıntılı yazdırabilirsiniz.(Fiş hareketleri
                                                ile birlikte).</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş raporunu excele aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Fiş Kar/Zarar Raporu alabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Teklif</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Alınan ve Verilen tekliflerinizi kayıt edebilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Teklif kayıtlarınızı fatura ve irsaliyeye
                                                aktarabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Satır bazında ve teklif bazında indirim yapabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Teklif formlarınızı kullandığınız matbuu forma göre dizayn
                                                edip yazdırabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Teklif raporu alabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Teklif raporunda aylık bazda toplamları görebilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Teklif raporunu yazdırabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Teklif raporunuzu excele aktarabilirsiniz.</p>
                                        </li>
                                    </ul>

                                    <h3>Banka</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Banka kayıtlarınızı oluşturabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka kayıtlarına dosya ekleyebilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka hesap türünü belirtebilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka Pos Provizyon oranlarını belirtebilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Bankalar arası viran yapabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka Kredi çekim formu oluşturup,
                                                taksitlendirebilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Pos vadesi gelen kayıtları banka hesabına
                                                aktarabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka hareket raporu alabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka hareket listesini yazdırabilirsiniz.</p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Banka hareket listesini excele aktarabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Kredi Kartı</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartlarınızın tanımlarını yapabilirsiniz.</p>
                                        <li class="list-item">
                                            <p class="p-lg">Kart limitini ve son ödeme gününü
                                                belirleyebilirsiniz.</p>
                                        <li class="list-item">
                                            <p class="p-lg">Borç Devri girebilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartı ödemelerinizi yapabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartı listesi alabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartı listesinde ay bazında yapılan ödeme, harcama
                                                ve bakiye bilgilerine
                                                ulaşabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartı listesinde kullanılabilir limiti
                                                görebilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartı hareket listesi alabilirsiniz.</p>

                                        <li class="list-item">
                                            <p class="p-lg">Kredi kartı hareket listesini yazdırabilir veya excele
                                                aktarabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Çek</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Alınan ve Verilen çeklerinizi kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çeklerinize vade tarihi girerek tahsilat/ödeme zamanı
                                                geldiğinde programın sizi
                                                uyarmasını sağlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çeklerinize ait özel kodlar tanımlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çeklerinizi bankadan veya kasadan ödeyebilir ve iade
                                                alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çeklerinizin cirolayabilir, nakit veya banka ödemesi
                                                alarak tahsilatlarınızı
                                                yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çek listesi alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çek listesini yazdırabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Senet</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Alınan ve Verilen senetlerinizi kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Senetlerinize vade tarihi girerek tahsilat/ödeme zamanı
                                                geldiğinde programın sizi
                                                uyarmasını sağlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Senetlerinize ait özel kodlar tanımlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Senetlerinizi bankadan veya kasadan ödeyebilir ve iade
                                                alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Senetlerinizi cirolayabilir, nakit veya banka ödemesi
                                                alarak tahsilatlarınızı
                                                yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Senet listesi alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Senet listesini yazdırabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Basit Üretim</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Üretim işlemlerinizi takip edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Üretim reçetelerinizi kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çoklu üretim yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Üretim listesi alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Üretim Reçetelerinizi yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Üretim listesini excele aktarabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Proje</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Proje kayıtlarınızı oluşturabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Projeye dosya ekleyebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kayıtlı olan projelerinizi Fatura, İrsaliye ve Cari vb.
                                                birçok modülde kullanarak
                                                projenizin maliyetini çıkarabilirsiniz..</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Projeye bağlı hareket listesini alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Projeye ait not girişi yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Projeler arası transfer yapabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Teknik servis</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Teknik seviş işlemlerini takip edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servis formu üzerinden sms
                                                gönderebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servis formu üzerinden müşterinizin eski
                                                servis formlarına ulaşabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servis formu yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servise ait barkod yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servis iş sonu formu yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servis listesi alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teslim edilecek veya devam eden teknik servis
                                                fişlerini ayrı ayrı görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Teknik servis listesini yazdırabilir veya excele
                                                aktarabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Müstahsil</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil işlemlerinizi takip edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Süt üreticilerinizin Stopaj, Borsa, Gelir vergisi,
                                                Mera Fonu ve Bağkur Primi
                                                kesintilerini otomatik hesaplatabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Aylık süt girişlerini yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil makbuzlarınızı kayıt edebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Örgüt bazında süt analizi alabilir ve excele
                                                aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Ticaret Odası Cetveli raporunu alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Bağkur Cetveli raporunu alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil icmali raporunu alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Süt ödeme listesi raporunu alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Ziraat bakası ödeme dosyasını oluşturabilirsiniz.
                                                Oluşturulan dosyayı ziraat bankası
                                                sistemine yükleyerek süt ödemelerinizi yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Vergi Dairesi Cetveli raporunu
                                                yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Vergi dairesi cetvelini excele aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çiğ Süt Destekleme Başvuru Dilekçesi raporunu
                                                yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Çiğ Süt Destekleme Başvuru Dilekçesi(3 Aylık)
                                                raporunu yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil makbuzu listesini alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil makbuzu listesi üzerinde düzenleme
                                                yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil makbuzlarını yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Müstahsil makbuzu listesini excele
                                                aktarabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Araç Takip</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Araç kayıtlarınızı oluşturabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç kayıtlarınıza dosya ekleyebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araçlarınıza ait Gelir ve Gider girişlerinizi
                                                yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Aktif ve pasif araçları ayrı ayrı
                                                görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç kantar girişlerini yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç kantar fişlerini Personel, Cari ve Araç bazında
                                                raporlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç akaryakıt alım fişlerini girebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç akaryakıt fişlerini Araç ve Cari bazında
                                                raporlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç listesi alabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç listesinde ay bazında gelir ve gider
                                                toplamlarını görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç listesini yazdırabilir veya excele
                                                aktarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Araç hareket listesi alabilir ve
                                                yazdırabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Taksit</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Carilerinize ait taksit işlemlerini
                                                yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit oluşturulabilecek evrakları
                                                görebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksitlendirme işleminde cumartesi ve pazar
                                                günlerini vade tarihinden
                                                çıkarabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksitlendirme işleminde küsurat
                                                hesaplatabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit işlemine ait sözleşme yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit işlemine ait detay bilgisi
                                                alabilirsiniz.(Taksitin hangi evraktan geldiği ve
                                                evrakta kullanılan stokalar vb.)</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit ödemelerini yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit ödemelerine ait özel kod
                                                belirleyebilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit ödemlerini nakit, kredi kart veya havale
                                                olarak yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Ödenmiş taksitleri listeye bilir veya
                                                yazdırabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Taksit hareket listesi alabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    <h3>Kullanıcı</h3>
                                    <ul class="simple-list">
                                        <li class="list-item">
                                            <p class="p-lg">Program kullanıcılarını tanımlayabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kullanıcı yetkilendirme yapabilirsiniz.</p>
                                        </li>
                                        <li class="list-item">
                                            <p class="p-lg">Kullanıcı yetkilendirme sayesinde modül bazında
                                                kullanıcılarınızı
                                                kısıtlayabilirsiniz.</p>
                                        </li>
                                    </ul>
                                    </p>


                                    <!-- Small Title -->
                                    <h5 class="h5-md mt-50">Praesent aliquet tempus<br/>
                                        (tempor gravida ipsum as an example)
                                    </h5>

                                    <!-- Text -->
                                    <p class="p-lg">Magna suscipit egestas magna ipsum vitae purus efficitur
                                        ipsum
                                        primis in cubilia
                                        laoreet augue egestas luctus donec diam. Curabitur dapibus libero.
                                        Mauris donec
                                        ociis a neque.
                                        Phasellus blandit tristique justo and aliquam vitae molestie nunc sapien
                                        justo,
                                        aliquet non molestie augue
                                    </p>

                                    <!-- List -->
                                    <ul class="simple-list">

                                        <li class="list-item">
                                            <p class="p-lg">Donec dolor magna, suscipit in magna dignissim,
                                                porttitor
                                                hendrerit diam.
                                                Nunc gravida ultrices felis eget faucibus. Praesent aliquet
                                                tempus,
                                                blandit posuere
                                                ligula varius
                                            </p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Quaerat sodales sapien undo euismod purus blandit
                                                velna
                                                vitae auctor a
                                                congue magna tempor sapien eget gravida laoreet turpis urna
                                                augue,
                                                viverra a augue
                                                eget, dictum tempor diam pulvinar consectetur purus efficitur
                                                ipsum
                                                primis in cubilia
                                                laoreet augue donec
                                            </p>
                                        </li>

                                    </ul>

                                    <!-- Text -->
                                    <p class="p-lg">Sagittis congue augue egestas volutpat egestas magna
                                        suscipit
                                        egestas magna ipsum
                                        vitae purus efficitur ipsum primis in cubilia laoreet augue egestas
                                        luctus donec
                                        diam. Curabitur dapibus libero. Mauris donec ociis a neque. Phasellus
                                        blandit
                                        tristique justo and
                                        aliquam vitae molestie nunc sapien justo, aliquet non molestie augue,
                                        venenatis
                                        nec purus
                                        aliquam eget lacinia elit tincidunt
                                    </p>

                                    <!-- BLOG POST INNER IMAGES -->
                                    <div class="post-inner-img">
                                        <div class="row">

                                            <!-- Inner Image #1 -->
                                            <div class="col-md-6 top-img blog-post-img">

                                                <!-- Image -->
                                                <img class="img-fluid" src="images/blog/quarkticari.jpg"
                                                     alt="blog-post-image"/>
                                                <!-- Text -->
                                                <p>Maecenas gravida CPU porttitor magna</p>

                                            </div>

                                            <!-- Inner Image #2 -->
                                            <div class="col-md-6 blog-post-img">

                                                <div class="video-preview">
                                                    <!-- Play Icon -->
                                                    <a class="video-popup1"
                                                       href="https://www.youtube.com/embed/WYLsWmbfAP0">
                                                        <div class="video-btn video-btn-lg bg-black ico-75">
                                                            <div class="video-block-wrapper"><span
                                                                    class="flaticon-play-button"></span></div>
                                                        </div>
                                                    </a>

                                                    <!-- Preview Image -->
                                                    <img class="img-fluid" src="images/blog/post-2-img.jpg"
                                                         alt="video-preview">

                                                </div>

                                                <!-- Text -->
                                                <p>Gravida porttitor nunc, quis vehicula tempor</p>

                                            </div>

                                        </div>
                                    </div>    <!-- END INNER IMAGES -->

                                    <!-- Text -->
                                    <p class="p-lg">Nulla tincidunt volutpat tincidunt. Pellentesque habitant
                                        morbi
                                        tristique senectus
                                        and netus laoreet malesuada famesa augue suscipit, luctus at neque purus
                                        neque
                                        dolor primis.
                                        Nemo sodales ipsam egestas volute turpis a dolores aliquam quaerat
                                        sodales
                                        sapien congue augue
                                        eget gravida laoreet turpis urna augue, viverra a augue eget, dictum
                                        dictum
                                        tempor diam pulvinar consectetur
                                    </p>

                                    <!-- QUOTE -->
                                    <div class="quote mt-30 mb-35">

                                        <!-- Quote Text -->
                                        <p class="p-xl">"Lorem ipsum dolor sit amet, consectetuer adipiscing
                                            elit.
                                            Aenean magna ligula
                                            eget dolor suscipit egestas viverra dolor iaculis luctus magna
                                            suscipit
                                            egestas suscipit in
                                            magna dignissim, porttitor hendrerit diam. Nunc gravida ultrices
                                            felis eget
                                            faucibus.
                                            Praesent aliquet tempus, blandit posuere ligula varius"
                                        </p>

                                    </div>


                                    <!-- Text -->
                                    <p class="p-lg">Nullam non scelerisque lectus. In at mauris vel nisl
                                        convallis porta
                                        at vitae dui.
                                        Nam lacus vulputate ligula molestie bibendum quis, aliquet elementum
                                        massa.
                                        Vestibulum ut
                                        sagittis purus massa lorem. Fusce eu cursus est. Fusce non nulla vitae
                                        massa
                                        placerat vulputate
                                        purus. Aliqum mullam a blandit tempor posuere ligula varius congue
                                        cursus congue
                                        magna impedit
                                        ligula
                                    </p>

                                    <!-- List -->
                                    <ul class="simple-list">

                                        <li class="list-item">
                                            <p class="p-lg">Donec dolor magna, suscipit in magna dignissim,
                                                porttitor
                                                hendrerit diam.
                                                Nunc gravida ultrices felis eget faucibus. Praesent aliquet
                                                tempus,
                                                blandit posuere
                                                ligula varius
                                            </p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Fringilla risus nec, luctus mauris orci auctor
                                                euismod purus
                                                pretium at
                                                purus pretium ligula rutrum tempor mullam blandit tempor sapien
                                                and
                                                gravida donec ipsum
                                                at justo
                                            </p>
                                        </li>

                                    </ul>

                                    <!-- Small Title -->
                                    <!-- Small Title -->
                                    <h5 class="h5-md">Egestas volutpat egestas</h5>

                                    <!-- Text -->
                                    <p class="p-lg">In at mauris vel nisl convallis porta at vitae dui. Nam
                                        lacus
                                        ligula, vulputate
                                        molestie bibendum quis, aliquet elementum massa. Vestibulum ut sagittis
                                        odio. Ac
                                        massa lorem.
                                        Fusce eu cursus est. Fusce non nulla vitae massa placerat vulputate vel
                                        a purus
                                        aliqum mullam
                                        blandit
                                    </p>

                                    <!-- Text -->
                                    <p class="p-lg">Maecenas gravida porttitor nunc, quis vehicula magna luctus
                                        tempor.
                                        Quisque
                                        laoreet a turpis urna augue, viverra a augue eget, dictum tempor diam.
                                        Sed
                                        pulvinar nibh, vel
                                        imperdiet congue varius viverra. Sapien justo massa lorem. Fusce eu
                                        cursus non
                                        nulla vitae
                                        massa placerat purus. Sagittis congue augue egestas volutpat egestas
                                        magna
                                        suscipit egestas
                                        magna ipsum vitae purus efficitur ipsum primis in cubilia laoreet augue
                                        egestas
                                        luctus donec
                                    </p>

                                    <!-- BLOG POST INNER IMAGE -->
                                    <div class="post-inner-img">
                                        <img class="img-fluid" src="images/img-19.png" alt="blog-post-image">
                                    </div>

                                    <!-- Small Title -->
                                    <h5 class="h5-md">Vitae massa placerat vulputate</h5>

                                    <!-- Text -->
                                    <p class="p-lg">Nullam non scelerisque lectus. In at mauris vel nisl
                                        convallis porta
                                        at vitae dui.
                                        Nam lacus vulputate ligula molestie bibendum quis, aliquet elementum
                                        massa.
                                        Vestibulum ut
                                        sagittis purus massa lorem. Fusce eu cursus est. Fusce non nulla vitae
                                        massa
                                        placerat vulputate
                                        purus. Aliqum mullam a blandit tempor posuere ligula varius congue
                                        cursus congue
                                        magna impedit
                                        ligula
                                    </p>

                                    <!-- Text -->
                                    <p class="p-lg"><span class="txt-600">Aliqum  mullam blandit tempor sapien gravida donec ipsum
									   </span>, at porta justo. Velna vitae and auctor congue magna impedit ligula
                                        risus. Mauris donec
                                        ociis magnis sapien etiam sapien sagittis congue posuere ligula varius
                                        congue
                                        cursus tempor
                                        gravida donec integer
                                    </p>

                                    <!-- Small Title -->
                                    <h5 class="h5-md">Cursus non nulla vitae massa</h5>

                                    <!-- List -->
                                    <ul class="simple-list">

                                        <li class="list-item">
                                            <p class="p-lg">Donec dolor magna, suscipit and magna dignissim,
                                                porttitor
                                                hendrerit diam.
                                                Gravida ultrices turpis and faucibus aliquet undo tempus,
                                                blandit
                                                posuere ligula varius
                                                congue cursus nulla vitae massa
                                            </p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Aliquam varius neque commodo purus tempor sapien
                                                gravida
                                                vulputate
                                                pharetra bibendum
                                            </p>
                                        </li>

                                        <li class="list-item">
                                            <p class="p-lg">Morbi lectus, lobortis felis nec, suscipit imperdiet
                                                sapien
                                                semper
                                                ultrices. Nulla tincidunt at volutpat and tincidunt. Habitant
                                                morbi
                                                tristique senectus
                                                et netus malesuada famesa augue suscipit, luctus neque purus
                                                ipsum
                                                bibendum quis,
                                                aliquet elementum
                                            </p>
                                        </li>

                                    </ul>

                                    <!-- Text -->
                                    <p class="p-lg">Curabitur ac dapibus libero quisque eu tristique neque
                                        sellus
                                        blandit tristique
                                        justo aliquam. Aliquam vitae at molestie nunc sapien justo, aliquet non
                                        molestie
                                        sed,
                                        venenatis nec purus. Aliquam lacinia at tincidunt massa justo. Quisque
                                        vel
                                        laoreet turpis.
                                        Urna augue, viverra a augue eget, dictum tempor diam. Sed pulvinar
                                        consectetur
                                        nibh imperdiet
                                        varius viverra. Pellentesque ac massa lorem. Fusce eu cursus est. Fusce
                                        non
                                        nulla vitae massa
                                        placerat bulum tincidunt tincidunt massa porttitor
                                    </p>

                                </div>    <!-- END BLOG POST TEXT -->


                                <!-- SINGLE POST SHARE LINKS -->
                                <div class="row post-share-links d-flex align-items-center">

                                    <!-- POST TAGS -->
                                    <div class="col-md-9 col-xl-8 post-tags-list">
                                        <span><a href="{{route("quarkticari")}}">Quark Ticari</a></span>
                                        <span><a href="{{route("quarkpos")}}">Quark Pos</a></span>
                                        <span><a href="{{route("quarkmobil")}}">Quark Mobil</a></span>
                                        <span><a href="{{route("quarkticari")}}">Quark Pos Lite</a></span>
                                    </div>

                                    <!-- POST SHARE ICONS -->
                                    <div class="col-md-3 col-xl-4 post-share-list text-end">
                                        <ul class="share-social-icons ico-25 text-center clearfix">
                                            <li><a href="https://www.twitter.com/qryazilim" class="share-ico"><span
                                                        class="flaticon-twitter"></span></a>
                                            </li>
                                            <li><a href="https://www.facebook.com/qryazilim" class="share-ico"><span
                                                        class="flaticon-facebook"></span></a></li>
                                            <li><a href="https://www.instagram.com/qryazilim" class="share-ico"><span
                                                        class="flaticon-instagram"></span></a></li> <li><a href="https://www.youtube.com/channel/UCBvrsvj9-1doM-yDb1zrCtw" class="share-ico"><span
                                                        class="flaticon-youtube"></span></a></li>
                                        </ul>
                                    </div>

                                </div>    <!-- END SINGLE POST SHARE -->

                            </div>
                        </div>
                    </div>    <!-- END SINGLE POST CONTENT -->


                </div>     <!-- End container -->
            </div>
        </section>    <!-- END SINGLE POST -->


        <!-- ABOUT POST AUTHOR
        ============================================= -->
    {{--        <div class="about-post-author bg-snow division">--}}
    {{--            <div class="container">--}}
    {{--                <div class="row">--}}
    {{--                    <div class="col-lg-10 offset-lg-1">--}}
    {{--                        <div class="author-senoff">--}}

    {{--                            <!-- Avatar -->--}}
    {{--                            <img src="images/review-author-7.jpg" alt="author-avatar">--}}

    {{--                            <!-- Text -->--}}
    {{--                            <div class="author-senoff-txt">--}}

    {{--                                <!-- Title -->--}}
    {{--                                <h5 class="h5-xs">Published by</h5>--}}
    {{--                                <h5 class="h5-md">Matthew Anderson</h5>--}}
    {{--                                <p class="p-md">Lorem ipsum dolor sit amet, consectetur elit eiusmod tempor sapien dolore--}}
    {{--                                    incidide ut labore dolore incididunt ut labore turpis vitae raesent varius consectetur--}}
    {{--                                    purus efficitur ipsum primis in cubilia laoreet augue donec--}}
    {{--                                </p>--}}

    {{--                                <!-- Link -->--}}
    {{--                                <p class="author-link">All stories by <a href="#">Matthew Anderson</a></p>--}}

    {{--                                <!-- Follow Button -->--}}
    {{--                                <div class="author-follow-btn"><a href="#">Follow</a></div>--}}

    {{--                            </div>--}}

    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                </div>  <!-- End row -->--}}
    {{--            </div>  <!-- End container -->--}}
    {{--        </div>	<!-- END ABOUT POST AUTHOR -->--}}




    <!-- POST COMMENTS
        ============================================= -->
        <section id="post-comments" class="wide-80 post-comments division">
            <div class="container">
                <div class="row">


                    <!-- COMMENTS WRAPPER -->
                    {{--                    <div class="col-lg-10 offset-lg-1">--}}
                    {{--                        <div class="comments-wrapper">--}}

                    {{--                            <!-- Title -->--}}
                    {{--                            <h5 class="h5-lg">4 Comments</h5>--}}


                    {{--                            <!-- COMMENT #1 -->--}}
                    {{--                            <div class="comment d-flex">--}}

                    {{--                                <!-- Comment-1 Avatar -->--}}
                    {{--                                <img src="images/review-author-2.jpg" alt="comment-avatar">--}}

                    {{--                                <!-- Comment-Body -->--}}
                    {{--                                <div class="comment-body">--}}

                    {{--                                    <!-- Comment-1 Meta -->--}}
                    {{--                                    <div class="comment-meta">--}}
                    {{--                                        <h6 class="h6-xl">Jamie</h6>--}}
                    {{--                                        <span class="comment-date">5 days ago&#8194;- </span>--}}
                    {{--                                        <span class="btn-reply ico-20">--}}
                    {{--												<a href="#leave-comment"><span class="flaticon-reply-arrow"></span> Reply</a>--}}
                    {{--											</span>--}}
                    {{--                                    </div>--}}

                    {{--                                    <!-- Comment-1 Text -->--}}
                    {{--                                    <p class="p-md mb-40">Etiam sapien sem magna at vitae pulvinar congue augue egestas pretium--}}
                    {{--                                        neque undo viverra suscipit egestas magna porta ratione, mollis risus lectus porta rutrum aenean primis in augue luctus neque purus ipsum neque dolor primis purus efficitur an--}}
                    {{--                                        ipsum primis in cubilia laoreet augue--}}
                    {{--                                    </p>--}}

                    {{--                                    <hr />--}}

                    {{--                                    <!-- Nested Comment -->--}}
                    {{--                                    <div class="comment d-flex">--}}

                    {{--                                        <!-- Nested Avatar -->--}}
                    {{--                                        <a href="#" class="pr-3">--}}
                    {{--                                            <img src="images/review-author-6.jpg" alt="comment-avatar">--}}
                    {{--                                        </a>--}}

                    {{--                                        <div class="comment-body">--}}

                    {{--                                            <!-- Comment-2 Meta -->--}}
                    {{--                                            <div class="comment-meta">--}}
                    {{--                                                <h6 class="h6-xl">Matthew Clark</h6>--}}
                    {{--                                                <span class="comment-date">6 days ago&#8194;- </span>--}}
                    {{--                                                <span class="btn-reply ico-20">--}}
                    {{--														<a href="#leave-comment"><span class="flaticon-reply-arrow"></span> Reply</a>--}}
                    {{--													</span>--}}
                    {{--                                            </div>--}}

                    {{--                                            <!-- Comment-2 Text -->--}}
                    {{--                                            <p class="p-md">Etiam sapien magna at vitae pulvinar congue egestas a pretium neque--}}
                    {{--                                                viverra suscipit porta ratione, mollis risus lectus porta aliquet lorem puruss--}}
                    {{--                                                mollis--}}
                    {{--                                            </p>--}}

                    {{--                                        </div>--}}

                    {{--                                    </div>	<!-- End Nested Comment -->--}}


                    {{--                                </div>--}}


                    {{--                            </div>	<!-- END COMMENT #1 -->--}}


                    {{--                            <hr />--}}


                    {{--                            <!-- COMMENT #3 -->--}}
                    {{--                            <div class="comment d-flex">--}}

                    {{--                                <!-- Comment Avatar -->--}}
                    {{--                                <img src="images/review-author-8.jpg" alt="comment-avatar">--}}

                    {{--                                <!-- Comment Body -->--}}
                    {{--                                <div class="comment-body">--}}

                    {{--                                    <!-- Comment Meta -->--}}
                    {{--                                    <div class="comment-meta">--}}
                    {{--                                        <h6 class="h6-xl">Olivia Steiner</h6>--}}
                    {{--                                        <span class="comment-date">13 days ago&#8194;- </span>--}}
                    {{--                                        <span class="btn-reply ico-20">--}}
                    {{--												<a href="#leave-comment"><span class="flaticon-reply-arrow"></span> Reply</a>--}}
                    {{--											</span>--}}
                    {{--                                    </div>--}}

                    {{--                                    <!-- Comment Text -->--}}
                    {{--                                    <p class="p-md">Porta ratione, mollis risus lectus porta rutrum arcu aenean primis in augue--}}
                    {{--                                        luctus and neque purus ipsum neque dolor primis libero tempus, tempor posuere ligula varius--}}
                    {{--                                        an impedit enim tempor vitae pulvinar at congue augue egestas praesent aliquet--}}
                    {{--                                    </p>--}}

                    {{--                                </div>	<!-- End Comment Body -->--}}

                    {{--                            </div>	<!-- END COMMENT #3 -->--}}


                    {{--                            <hr />--}}


                    {{--                            <!-- COMMENT #4 -->--}}
                    {{--                            <div class="comment d-flex">--}}

                    {{--                                <!-- Comment Avatar -->--}}
                    {{--                                <img src="images/review-author-3.jpg" alt="comment-avatar">--}}

                    {{--                                <!-- Comment Body -->--}}
                    {{--                                <div class="comment-body">--}}

                    {{--                                    <!-- Comment Meta -->--}}
                    {{--                                    <div class="comment-meta">--}}
                    {{--                                        <h6 class="h6-xl">C. Johnson</h6>--}}
                    {{--                                        <span class="comment-date">42 days ago&#8194;- </span>--}}
                    {{--                                        <span class="btn-reply ico-20">--}}
                    {{--												<a href="#leave-comment"><span class="flaticon-reply-arrow"></span> Reply</a>--}}
                    {{--											</span>--}}
                    {{--                                    </div>--}}

                    {{--                                    <!-- Comment Text -->--}}
                    {{--                                    <p class="p-md">Etiam sapien sem magna at vitae pulvinar congue augue egestas pretium neque--}}
                    {{--                                        undo viverra suscipit  egestas magna porta ratione, mollis risus lectus porta rutrum arcu--}}
                    {{--                                    </p>--}}

                    {{--                                </div>	<!-- End Comment Body -->--}}

                    {{--                            </div>	<!-- END COMMENT #4 -->--}}


                    {{--                            <hr />--}}


                    {{--                            <!-- COMMENT FORM -->--}}
                    {{--                            <div id="leave-comment">--}}

                    {{--                                <!-- Title -->--}}
                    {{--                                <h5 class="h5-lg">Leave a Comment</h5>--}}

                    {{--                                <!-- Text -->--}}
                    {{--                                <p class="p-md">Your email address will not be published. Required fields are marked *</p>--}}

                    {{--                                <form name="commentForm" class="row comment-form">--}}

                    {{--                                    <div class="col-md-12 input-message">--}}
                    {{--                                        <p>Add Comment *</p>--}}
                    {{--                                        <textarea class="form-control message" name="message" rows="6" placeholder="Enter Your Comment Here* ..." required></textarea>--}}
                    {{--                                    </div>--}}

                    {{--                                    <div class="col-md-12">--}}
                    {{--                                        <p>Name*</p>--}}
                    {{--                                        <input type="text" name="name" class="form-control name" placeholder="Enter Your Name*" required>--}}
                    {{--                                    </div>--}}

                    {{--                                    <div class="col-md-12">--}}
                    {{--                                        <p>Email*</p>--}}
                    {{--                                        <input type="email" name="email" class="form-control email" placeholder="Enter Your Email*" required>--}}
                    {{--                                    </div>--}}

                    {{--                                    <!-- Contact Form Button -->--}}
                    {{--                                    <div class="col-lg-12 form-btn">--}}
                    {{--                                        <button type="submit" class="btn btn-skyblue tra-skyblue-hover submit">Post Comment</button>--}}
                    {{--                                    </div>--}}

                    {{--                                    <!-- Contact Form Message -->--}}
                    {{--                                    <div class="col-md-12 comment-form-msg text-center">--}}
                    {{--                                        <div class="sending-msg"><span class="loading"></span></div>--}}
                    {{--                                    </div>--}}

                    {{--                                </form>--}}

                    {{--                            </div>	<!-- END COMMENT FORM -->--}}

                    {{--                        </div>--}}
                    {{--                    </div>	<!-- END COMMENTS WRAPPER -->--}}


                    {{--                </div>     <!-- End row -->--}}
                </div>     <!-- End container -->
            </div>
        </section>    <!-- END POST COMMENTS -->


        <!-- BLOG-1
        ============================================= -->
        <section id="blog-1" class="bg-whitesmoke-gradient wide-60 blog-section division">
            <div class="container">


                <!-- SECTION TITLE -->
                <div class="row justify-content-center">
                    <div class="col-lg-10 col-xl-8">
                        <div class="section-title title-01 mb-70 wow fadeInUp" data-wow-delay="0.4s">
                            <h2 class="h2-md">Diğer Quark Ürünlerimiz...</h2>
                        </div>
                    </div>
                </div>


                <!-- BLOG POSTS -->
                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3">

                    <!-- Quark Ticari -->
                    <div class="col">
                        <div id="bp-1-1" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkticari")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkticari.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Ticari</p>

                                <!-- Post Link -->
                                <h5 class="h5-sm">
                                    <a href="single-post.html">Quark Ticari Ön Muhasebe Programı</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>OLMO News &ensp;|&ensp; 9 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #1 -->

                    <!-- Quark Mobil -->
                    <div class="col">
                        <div id="bp-1-2" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkmobil")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkmobil.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Mobil</p>

                                <!-- Post Link -->
                                <h5 class="h5-sm">
                                    <a href="single-post.html">Quark Mobil</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta a mauris luctus
                                    dolor...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Tutorials &ensp;|&ensp; 12 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #2 -->

                    <!-- Quark Pos -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkpos")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkpos.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 --> <!-- BLOG POST #3 -->

                   <!-- Quark Pos Lite -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkposlite")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkposlite.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 -->

                   <!-- Quark Restorant -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkres")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkres.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 -->

                   <!-- Quark Sulama -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarksulama")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarksulama.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 -->

                    <!-- Quark Doğrudan temin -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkdtemin")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkdtemin.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 -->

                    <!-- Quark Analitik bütçe muhasebe -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarkanalitik")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarkanalitik.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 -->

                    <!-- Quark safe veresiye -->
                    <div class="col">
                        <div id="bp-1-3" class="blog-1-post mb-40 wow fadeInUp">

                            <!-- BLOG POST IMAGE -->
                            <div class="blog-post-img">
                                <a href="{{route("quarksafe")}}"> <img class="img-fluid"
                                                                         src="images/blog/quarksafe.jpg"
                                                                         alt="blog-post-image"/></a>
                            </div>

                            <!-- BLOG POST TEXT -->
                            <div class="blog-post-txt">

                                <!-- Post Tag -->
                                <p class="post-tag">Quark Hızlı Satış</p>

                                <!-- Post Link -->
                                <h5 class="h5-xs">
                                    <a href="single-post.html">Quark (Pos) Hızlı Satış</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">Donec sapien augue integer turpis urna cursus porta, mauris augue
                                    luctus...</p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>Inspiration &ensp;|&ensp; 3 Comments</p></div>

                            </div>    <!-- END BLOG POST TEXT -->

                        </div>
                    </div>    <!-- END  BLOG POST #4 -->
                </div>    <!-- END BLOG POSTS -->


            </div>       <!-- End container -->
        </section>    <!-- END BLOG-1 -->


        <!-- NEWSLETTER-1
        ============================================= -->
        <section id="newsletter-1" class="newsletter-section division">
            <div class="container">
                <div class="newsletter-wrapper bg-white">
                    <div class="row d-flex align-items-center row-cols-1 row-cols-lg-2">


                        <!-- NEWSLETTER TEXT -->
                        <div class="col">
                            <div class="newsletter-txt pr-20">

                                <!-- Title -->
                                <h4 class="h4-xl">Haberlerimiz, fikirlerimiz ve güncellemelerimizle güncel kalın.</h4>

                            </div>
                        </div>


                        <!-- NEWSLETTER FORM -->
                        <div class="col">
                            <form class="newsletter-form">

                                <div class="input-group">
                                    <input type="email" autocomplete="off" class="form-control"
                                           placeholder="E-posta Adresiniz" required id="s-email">
                                    <span class="input-group-btn">
											<button type="submit" class="btn btn-md btn-skyblue tra-grey-hover">Abone Ol</button>
										</span>
                                </div>

                                <!-- Newsletter Form Notification -->
                                <label for="s-email" class="form-notification"></label>

                            </form>
                        </div>      <!-- END NEWSLETTER FORM -->


                    </div>      <!-- End row -->
                </div>    <!-- End newsletter-wrapper -->
            </div>       <!-- End container -->
        </section>    <!-- END NEWSLETTER-1 -->

    </div>
@endsection
@section('js')

@endsection
@section('css')
    <link rel="stylesheet" href="{{asset('assest/css/theme-elements.css')}}">
@endsection

