@extends('front.layouts.master')
@section('title','QR Yazılım Ürünleri - QR Yazılım')
@section('description', 'Quark Ürünleri sizlere özel hizmetleriyle birlikte kullanıma hazır.')
@section('menustyle','dark')
@section('content')
    <section id="blog-page" class="bg-snow wide-50 inner-page-hero blog-page-section division">
        <div class="container">


            <!-- SECTION TITLE -->
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8">
                    <div class="section-title title-02 mb-85">
                        <h3 class="h3-xl">QR Yazılım Programları</h3>
                        <p>Quark Ürünleri sizlere özel hizmetleriyle birlikte kullanıma hazır.</p>
                    </div>
                </div>
            </div>

            <?php
                $i = 1;
                ?>
            @foreach($urunler as $urun)
                <div class="rel blog-post-wide featured-post">
                    <div class="row d-flex align-items-center">

                        <!-- Featured Badge -->
                        <div class="featured-badge ico-25 bg-whitesmoke yellow-color">
                            <span class="flaticon-star-1"></span>
                        </div>
                @if($i%2 == 0)
                            <!-- BLOG POST IMAGE -->
                            <div class="col-lg-7 blog-post-img">
                                <a href="{{route("urungetir",["id"=>$urun->id])}}"><img class="img-fluid" src="{{$urun->program_resim}}" alt="blog-post-image" /></a>
                            </div>
                            <!-- BLOG POST TEXT -->
                            <div class="col-lg-5 blog-post-txt">

                                <!-- Post Link -->
                                <h5 class="h5-xl">
                                    <a href="{{route("urungetir",["id"=>$urun->id])}}">{{$urun->program_kisa_adi}} Kullanışlı modülleri ile size hizmete hazır.</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">{{$urun->program_kisa_aciklama}} </p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>{{$urun->program_kisa_adi}} &ensp;|&ensp;</p></div>

                            </div>	<!-- END BLOG POST TEXT -->
                @else

                            <!-- BLOG POST TEXT -->
                            <div class="col-lg-5 blog-post-txt">

                                <!-- Post Link -->
                                <h5 class="h5-xl">
                                    <a href="{{route("urungetir",["id"=>$urun->id])}}">{{$urun->program_kisa_adi}} Kullanışlı modülleri ile size hizmete hazır.</a>
                                </h5>

                                <!-- Text -->
                                <p class="p-lg">{{$urun->program_kisa_aciklama}}
                                </p>

                                <!-- Post Meta -->
                                <div class="post-meta"><p>{{$urun->program_kisa_adi}} &ensp;|&ensp;</p></div>

                            </div>	<!-- END BLOG POST TEXT -->

                            <!-- BLOG POST IMAGE -->
                            <div class="col-lg-7 blog-post-img">
                                <a href="{{route("urungetir",["id"=>$urun->id])}}"><img class="img-fluid" src="{{$urun->program_resim}}" alt="blog-post-image" /></a>
                            </div>

                        @endif
                    </div>   <!-- End row -->
                </div>	<!-- END FEATURED POST -->
                <?php
                $i++;
                ?>
            @endforeach

            <!-- Quark Ticari -->







            <!-- NEWSLETTER-1
            ============================================= -->
            <section id="newsletter-1" class="bg-snow newsletter-section division">
                <div class="container">
                    <div class="newsletter-wrapper bg-white">
                        <div class="row d-flex align-items-center row-cols-1 row-cols-lg-2">


                            <!-- NEWSLETTER TEXT -->
                            <div class="col">
                                <div class="newsletter-txt pr-20">
                                    <h4 class="h4-xl">Haberlerimiz, fikirlerimiz ve güncellemelerimizle güncel kalın.</h4>
                                </div>
                            </div>


                            <!-- NEWSLETTER FORM -->
                            <div class="col">
                                <form class="newsletter-form">
                                    <div class="input-group">
                                        <input type="email" autocomplete="off" class="form-control" placeholder="Your email address" required id="s-email">
                                        <span class="input-group-btn">
											<button type="submit" class="btn btn-md btn-skyblue tra-grey-hover">Abone Ol</button>
										</span>
                                    </div>

                                    <!-- Newsletter Form Notification -->
                                    <label for="s-email" class="form-notification"></label>
                                </form>
                            </div>	  <!-- END NEWSLETTER FORM -->
                        </div>	  <!-- End row -->
                    </div>    <!-- End newsletter-wrapper -->
                </div>	   <!-- End container -->
            </section>	<!-- END NEWSLETTER-1 -->

        </div>
    </section>


@endsection


@section('css')

@endsection


@section('js')

@endsection
